/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.killbill.billing.lifecycle.ServiceFinder;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecycle
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(DefaultLifecycle.class);
    private final SortedSetMultimap<LifecycleHandlerType.LifecycleLevel, LifecycleHandler<? extends KillbillService>> handlersByLevel = Multimaps.newSortedSetMultimap(new ConcurrentHashMap(), (Supplier)new Supplier<SortedSet<LifecycleHandler<? extends KillbillService>>>(){

        public SortedSet<LifecycleHandler<? extends KillbillService>> get() {
            return new TreeSet<LifecycleHandler<? extends KillbillService>>();
        }
    });

    @Inject
    public DefaultLifecycle(Injector injector) {
        this();
        ServiceFinder<KillbillService> serviceFinder = new ServiceFinder<KillbillService>(DefaultLifecycle.class.getClassLoader(), KillbillService.class.getName());
        this.init(serviceFinder, injector);
    }

    public DefaultLifecycle(Set<? extends KillbillService> services) {
        this();
        this.init(services);
    }

    private DefaultLifecycle() {
    }

    @Override
    public void fireStartupSequencePriorEventRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.STARTUP_PRE_EVENT_REGISTRATION);
    }

    @Override
    public void fireStartupSequencePostEventRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.STARTUP_POST_EVENT_REGISTRATION);
    }

    @Override
    public void fireShutdownSequencePriorEventUnRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.SHUTDOWN_PRE_EVENT_UNREGISTRATION);
    }

    @Override
    public void fireShutdownSequencePostEventUnRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.SHUTDOWN_POST_EVENT_UNREGISTRATION);
    }

    private Set<? extends KillbillService> findServices(Set<Class<? extends KillbillService>> services, Injector injector) {
        HashSet<KillbillService> result = new HashSet<KillbillService>();
        for (Class<? extends KillbillService> cur : services) {
            log.debug("Found service {}", (Object)cur.getName());
            try {
                KillbillService instance = (KillbillService)injector.getInstance(cur);
                log.debug("got instance {}", (Object)instance.getName());
                result.add(instance);
            }
            catch (ConfigurationException e) {
                if (cur.getSimpleName().startsWith("Test")) continue;
                this.logWarn("Failed to inject " + cur.getName(), null);
            }
            catch (ProvisionException e) {
                if (cur.getSimpleName().startsWith("Test")) continue;
                this.logWarn("Failed to inject " + cur.getName(), (Exception)((Object)e));
            }
        }
        return result;
    }

    private void init(ServiceFinder<KillbillService> serviceFinder, Injector injector) {
        this.init(serviceFinder.getServices(), injector);
    }

    private void init(Set<Class<? extends KillbillService>> servicesClasses, Injector injector) {
        Set<? extends KillbillService> services = this.findServices(servicesClasses, injector);
        this.init(services);
    }

    private void init(Set<? extends KillbillService> services) {
        for (KillbillService killbillService : services) {
            this.handlersByLevel.putAll(this.findAllHandlers(killbillService));
        }
    }

    private void fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence seq) {
        List levels = LifecycleHandlerType.LifecycleLevel.getLevelsForSequence((LifecycleHandlerType.LifecycleLevel.Sequence)seq);
        for (LifecycleHandlerType.LifecycleLevel cur : levels) {
            this.doFireStage(cur);
        }
    }

    private void doFireStage(LifecycleHandlerType.LifecycleLevel level) {
        log.info("Killbill lifecycle firing stage {}", (Object)level);
        SortedSet handlers = this.handlersByLevel.get((Object)level);
        for (LifecycleHandler cur : handlers) {
            try {
                Method method = cur.getMethod();
                Object target = cur.getTarget();
                log.info("Killbill lifecycle calling handler {} for service {}", (Object)cur.getMethod().getName(), (Object)target.getName());
                method.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                this.logWarn("Killbill lifecycle failed to invoke lifecycle handler", e);
            }
        }
    }

    protected void logWarn(String msg, @Nullable Exception e) {
        if (e == null) {
            log.warn(msg);
        } else {
            log.warn(msg, (Throwable)e);
        }
    }

    private Multimap<LifecycleHandlerType.LifecycleLevel, LifecycleHandler<? extends KillbillService>> findAllHandlers(KillbillService service) {
        HashMultimap methodsInService = HashMultimap.create();
        Class<?> clazz = service.getClass();
        for (Method method : clazz.getMethods()) {
            LifecycleHandlerType annotation = method.getAnnotation(LifecycleHandlerType.class);
            if (annotation == null) continue;
            LifecycleHandlerType.LifecycleLevel level = annotation.value();
            LifecycleHandler handler = new LifecycleHandler(this, service, method);
            methodsInService.put((Object)level, (Object)handler);
        }
        return methodsInService;
    }

    SortedSetMultimap<LifecycleHandlerType.LifecycleLevel, LifecycleHandler<? extends KillbillService>> getHandlersByLevel() {
        return this.handlersByLevel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LifecycleHandler<T extends KillbillService>
    implements Comparable<LifecycleHandler> {
        private final T target;
        private final Method method;
        final /* synthetic */ DefaultLifecycle this$0;

        public LifecycleHandler(T target, Method method) {
            this.this$0 = this$0;
            this.target = target;
            this.method = method;
        }

        public T getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LifecycleHandler that = (LifecycleHandler)o;
            return Objects.equal(this.target, that.target) && Objects.equal((Object)this.method, (Object)that.method);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.target, this.method});
        }

        @Override
        public int compareTo(LifecycleHandler o) {
            if (this.target.getRegistrationOrdering() < o.getTarget().getRegistrationOrdering()) {
                return -1;
            }
            if (this.target.getRegistrationOrdering() > o.getTarget().getRegistrationOrdering()) {
                return 1;
            }
            return Integer.valueOf(this.target.hashCode()).compareTo(o.hashCode());
        }
    }
}

