/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle.bus;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.killbill.billing.lifecycle.api.ExternalBusService;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.bus.api.PersistentBus;

public class DefaultExternalBusService
implements ExternalBusService {
    private final PersistentBus eventBus;

    @Inject
    public DefaultExternalBusService(@Named(value="externalBus") PersistentBus eventBus) {
        this.eventBus = eventBus;
    }

    public String getName() {
        return KillbillService.KILLBILL_SERVICES.EXTERNAL_BUS_SERVICE.getServiceName();
    }

    public int getRegistrationOrdering() {
        return KillbillService.KILLBILL_SERVICES.EXTERNAL_BUS_SERVICE.getRegistrationOrdering();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_BUS)
    public void startBus() {
        this.eventBus.start();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_BUS)
    public void stopBus() {
        this.eventBus.stop();
    }

    public PersistentBus getBus() {
        return this.eventBus;
    }
}

