/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.lifecycle.ServiceFinder;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.lifecycle.config.LifecycleConfig;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycle
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(DefaultLifecycle.class);
    private final Map<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>> handlersByLevel = new ConcurrentHashMap<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>>();
    private final LifecycleConfig config;

    @Inject
    public DefaultLifecycle(Injector injector, LifecycleConfig config) {
        this(config);
        ServiceFinder<KillbillService> serviceFinder = new ServiceFinder<KillbillService>(DefaultLifecycle.class.getClassLoader(), KillbillService.class.getName());
        this.init(serviceFinder, injector);
    }

    public DefaultLifecycle(Iterable<? extends KillbillService> services) {
        this((LifecycleConfig)null);
        this.init(services);
    }

    private DefaultLifecycle(LifecycleConfig config) {
        this.config = config;
    }

    @Override
    public void fireStartupSequencePriorEventRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.STARTUP_PRE_EVENT_REGISTRATION);
    }

    @Override
    public void fireStartupSequencePostEventRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.STARTUP_POST_EVENT_REGISTRATION);
    }

    @Override
    public void fireShutdownSequencePriorEventUnRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.SHUTDOWN_PRE_EVENT_UNREGISTRATION);
    }

    @Override
    public void fireShutdownSequencePostEventUnRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.SHUTDOWN_POST_EVENT_UNREGISTRATION);
    }

    private Set<? extends KillbillService> findServices(Set<Class<? extends KillbillService>> services, Injector injector) {
        HashSet<KillbillService> result = new HashSet<KillbillService>();
        for (Class<? extends KillbillService> cur : services) {
            log.debug("Found service {}", (Object)cur.getName());
            try {
                KillbillService instance = (KillbillService)injector.getInstance(cur);
                log.debug("got instance {}", (Object)instance.getName());
                result.add(instance);
            }
            catch (ConfigurationException e) {
                if (cur.getSimpleName().startsWith("Test")) continue;
                this.logWarn("Failed to inject " + cur.getName(), null);
            }
            catch (ProvisionException e) {
                if (cur.getSimpleName().startsWith("Test")) continue;
                this.logWarn("Failed to inject " + cur.getName(), (Exception)((Object)e));
            }
        }
        return result;
    }

    private void init(ServiceFinder<KillbillService> serviceFinder, Injector injector) {
        this.init(serviceFinder.getServices(), injector);
    }

    private void init(Set<Class<? extends KillbillService>> servicesClasses, Injector injector) {
        Set<? extends KillbillService> services = this.findServices(servicesClasses, injector);
        this.init(services);
    }

    private void init(Iterable<? extends KillbillService> services) {
        for (KillbillService killbillService : services) {
            Map<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>> values = this.findAllHandlers(killbillService);
            for (Map.Entry<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>> entry : values.entrySet()) {
                if (this.handlersByLevel.get(entry.getKey()) != null) {
                    this.handlersByLevel.get(entry.getKey()).addAll((Collection<LifecycleHandler<? extends KillbillService>>)entry.getValue());
                    continue;
                }
                this.handlersByLevel.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence seq) {
        List levels = LifecycleHandlerType.LifecycleLevel.getLevelsForSequence((LifecycleHandlerType.LifecycleLevel.Sequence)seq);
        for (LifecycleHandlerType.LifecycleLevel cur : levels) {
            this.doFireStage(cur);
        }
    }

    private void doFireStage(LifecycleHandlerType.LifecycleLevel level) {
        log.info("Killbill lifecycle firing stage {}", (Object)level);
        Set handlers = this.handlersByLevel.getOrDefault(level, new TreeSet());
        for (LifecycleHandler cur : handlers) {
            try {
                Method method = cur.getMethod();
                Object target = cur.getTarget();
                log.info("Killbill lifecycle calling handler {} for service {}", (Object)cur.getMethod().getName(), (Object)target.getName());
                method.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                this.logWarn("Killbill lifecycle failed to invoke lifecycle handler", e);
                if (!this.config.isServerExitOnLifecycleError()) continue;
                log.warn("Exiting as system was configured to exit on lifecycle error ");
                System.exit(1);
            }
        }
    }

    protected void logWarn(String msg, @Nullable Exception e) {
        if (e == null) {
            log.warn(msg);
        } else {
            log.warn(msg, (Throwable)e);
        }
    }

    private Map<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>> findAllHandlers(KillbillService service) {
        HashMap<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>> methodsInService = new HashMap<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>>();
        Class<?> clazz = service.getClass();
        for (Method method : clazz.getMethods()) {
            LifecycleHandlerType annotation = method.getAnnotation(LifecycleHandlerType.class);
            if (annotation == null) continue;
            LifecycleHandlerType.LifecycleLevel level = annotation.value();
            LifecycleHandler<KillbillService> handler = new LifecycleHandler<KillbillService>(service, method);
            if (methodsInService.get(level) != null) {
                ((SortedSet)methodsInService.get(level)).add(handler);
                continue;
            }
            TreeSet<LifecycleHandler<KillbillService>> handlers = new TreeSet<LifecycleHandler<KillbillService>>();
            handlers.add(handler);
            methodsInService.put(level, handlers);
        }
        return methodsInService;
    }

    Map<LifecycleHandlerType.LifecycleLevel, SortedSet<LifecycleHandler<? extends KillbillService>>> getHandlersByLevel() {
        return this.handlersByLevel;
    }

    static final class LifecycleHandler<T extends KillbillService>
    implements Comparable<LifecycleHandler<?>> {
        private final T target;
        private final Method method;

        public LifecycleHandler(T target, Method method) {
            this.target = target;
            this.method = method;
        }

        public T getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LifecycleHandler that = (LifecycleHandler)o;
            return Objects.equals(this.target, that.target) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.target, this.method);
        }

        @Override
        public int compareTo(LifecycleHandler o) {
            if (this.target.getRegistrationOrdering() < o.getTarget().getRegistrationOrdering()) {
                return -1;
            }
            if (this.target.getRegistrationOrdering() > o.getTarget().getRegistrationOrdering()) {
                return 1;
            }
            return Integer.compare(this.target.hashCode(), o.hashCode());
        }
    }
}

