/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle.glue;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.killbill.bus.DefaultPersistentBus;
import org.killbill.bus.InMemoryPersistentBus;
import org.killbill.bus.api.PersistentBus;
import org.killbill.bus.api.PersistentBusConfig;
import org.killbill.clock.Clock;
import org.killbill.commons.jdbi.notification.DatabaseTransactionNotificationApi;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentBusProvider
implements Provider<PersistentBus> {
    private static final Logger logger = LoggerFactory.getLogger(PersistentBusProvider.class);
    private final PersistentBusConfig busConfig;
    private IDBI dbi;
    private Clock clock;
    private MetricRegistry metricRegistry;
    private DatabaseTransactionNotificationApi databaseTransactionNotificationApi;

    public PersistentBusProvider(PersistentBusConfig busConfig) {
        this.busConfig = busConfig;
    }

    @Inject
    public void initialize(@Named(value="Queue") IDBI dbi, DatabaseTransactionNotificationApi observable, Clock clock, MetricRegistry metricRegistry) {
        this.dbi = dbi;
        this.clock = clock;
        this.metricRegistry = metricRegistry;
        this.databaseTransactionNotificationApi = observable;
    }

    public PersistentBus get() {
        if (this.busConfig.isInMemory()) {
            logger.info("Creating InMemory bus for " + this.busConfig.getTableName());
            return new InMemoryPersistentBus(this.busConfig);
        }
        logger.info("Creating Persistent bus for " + this.busConfig.getTableName());
        return new DefaultPersistentBus(this.dbi, this.clock, this.busConfig, this.metricRegistry, this.databaseTransactionNotificationApi);
    }
}

