/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle.glue;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.lifecycle.api.ExternalBusService;
import org.killbill.billing.lifecycle.bus.DefaultBusService;
import org.killbill.billing.lifecycle.bus.DefaultExternalBusService;
import org.killbill.billing.lifecycle.glue.PersistentBusProvider;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.bus.InMemoryPersistentBus;
import org.killbill.bus.api.PersistentBus;
import org.killbill.bus.api.PersistentBusConfig;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;

public class BusModule
extends AbstractModule {
    public static final String EXTERNAL_BUS_NAMED = "externalBus";
    private final BusType type;
    private final boolean isExternal;
    private final KillbillConfigSource configSource;

    public BusModule(BusType type, boolean isExternal, KillbillConfigSource configSource) {
        this.type = type;
        this.isExternal = isExternal;
        this.configSource = configSource;
    }

    protected void configure() {
        SkifePersistentBusConfigSource skifePersistentBusConfigSource = new SkifePersistentBusConfigSource();
        PersistentBusConfig busConfig = (PersistentBusConfig)new ConfigurationObjectFactory((ConfigSource)skifePersistentBusConfigSource).buildWithReplacements(PersistentBusConfig.class, Map.of("instanceName", this.isExternal ? "external" : "main"));
        if (this.isExternal) {
            this.bind(ExternalBusService.class).to(DefaultExternalBusService.class).asEagerSingleton();
        } else {
            this.bind(BusService.class).to(DefaultBusService.class).asEagerSingleton();
        }
        switch (this.type) {
            case MEMORY: {
                this.configureInMemoryEventBus(busConfig);
                break;
            }
            case PERSISTENT: {
                this.configurePersistentEventBus(busConfig);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized EventBus type " + this.type);
            }
        }
    }

    protected void configurePersistentEventBus(PersistentBusConfig busConfig) {
        PersistentBusProvider busProvider = new PersistentBusProvider(busConfig);
        if (this.isExternal) {
            this.bind(PersistentBusProvider.class).annotatedWith((Annotation)Names.named((String)EXTERNAL_BUS_NAMED)).toInstance((Object)busProvider);
            this.bind(PersistentBus.class).annotatedWith((Annotation)Names.named((String)EXTERNAL_BUS_NAMED)).toProvider(Key.get(PersistentBusProvider.class, (Annotation)Names.named((String)EXTERNAL_BUS_NAMED))).asEagerSingleton();
        } else {
            this.bind(PersistentBusProvider.class).toInstance((Object)busProvider);
            this.bind(PersistentBus.class).toProvider(PersistentBusProvider.class).asEagerSingleton();
        }
    }

    private void configureInMemoryEventBus(PersistentBusConfig busConfig) {
        this.bind(PersistentBusConfig.class).toInstance((Object)busConfig);
        this.bind(PersistentBus.class).to(InMemoryPersistentBus.class).asEagerSingleton();
    }

    private final class SkifePersistentBusConfigSource
    implements ConfigSource {
        private SkifePersistentBusConfigSource() {
        }

        public String getString(String propertyName) {
            return BusModule.this.configSource.getString(propertyName);
        }
    }

    public static enum BusType {
        MEMORY,
        PERSISTENT;

    }
}

