/*
 * Copyright 2014-2018 Groupon, Inc
 * Copyright 2014-2018 The Billing Project, LLC
 *
 * The Billing Project licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.killbill.billing.osgi.api;

import java.util.UUID;

import org.killbill.billing.util.callcontext.TenantContext;

public class ROTenantContext implements TenantContext {

    private final TenantContext delegate;

    public ROTenantContext(final TenantContext delegate) {
        this.delegate = delegate;
    }

    @Override
    public UUID getAccountId() {
        return delegate.getAccountId();
    }

    @Override
    public UUID getTenantId() {
        return delegate.getTenantId();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ROTenantContext that = (ROTenantContext) o;

        return delegate != null ? delegate.equals(that.delegate) : that.delegate == null;
    }

    @Override
    public int hashCode() {
        return delegate != null ? delegate.hashCode() : 0;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ROTenantContext{");
        sb.append("delegate=").append(delegate);
        sb.append('}');
        return sb.toString();
    }
}
