/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.killbill.osgi.libs.killbill;

import java.lang.reflect.InvocationTargetException;
import org.killbill.billing.osgi.api.OSGIKillbillRegistrar;
import org.killbill.killbill.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.killbill.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.killbill.osgi.libs.killbill.OSGIKillbillDataSource;
import org.killbill.killbill.osgi.libs.killbill.OSGIKillbillEventDispatcher;
import org.killbill.killbill.osgi.libs.killbill.OSGIKillbillLogService;
import org.killbill.killbill.osgi.libs.killbill.OSGIServiceNotAvailable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public abstract class KillbillActivatorBase
implements BundleActivator {
    protected OSGIKillbillAPI killbillAPI;
    protected OSGIKillbillLogService logService;
    protected OSGIKillbillRegistrar registrar;
    protected OSGIKillbillDataSource dataSource;
    protected OSGIKillbillEventDispatcher dispatcher;
    protected OSGIConfigPropertiesService configProperties;

    public void start(BundleContext context) throws Exception {
        OSGIKillbillEventDispatcher.OSGIFrameworkEventHandler frameworkEventHandler;
        this.killbillAPI = new OSGIKillbillAPI(context);
        this.logService = new OSGIKillbillLogService(context);
        this.configureSLF4JBinding();
        this.dataSource = new OSGIKillbillDataSource(context);
        this.dispatcher = new OSGIKillbillEventDispatcher(context);
        this.configProperties = new OSGIConfigPropertiesService(context);
        this.registrar = new OSGIKillbillRegistrar();
        OSGIKillbillEventDispatcher.OSGIKillbillEventHandler handler = this.getOSGIKillbillEventHandler();
        if (handler != null) {
            this.dispatcher.registerEventHandler(handler);
        }
        if ((frameworkEventHandler = this.getOSGIFrameworkEventHandler()) != null) {
            this.dispatcher.registerEventHandler(frameworkEventHandler);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.killbillAPI != null) {
            this.killbillAPI.close();
            this.killbillAPI = null;
        }
        if (this.dispatcher != null) {
            this.dispatcher.close();
            this.dispatcher = null;
        }
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
        if (this.logService != null) {
            this.logService.close();
            this.logService = null;
        }
        try {
            OSGIKillbillEventDispatcher.OSGIKillbillEventHandler handler = this.getOSGIKillbillEventHandler();
            if (handler != null && this.dispatcher != null) {
                this.dispatcher.unregisterEventHandler(handler);
                this.dispatcher = null;
            }
        }
        catch (OSGIServiceNotAvailable oSGIServiceNotAvailable) {
            // empty catch block
        }
        if (this.registrar != null) {
            this.registrar.unregisterAll();
            this.registrar = null;
        }
    }

    public abstract OSGIKillbillEventDispatcher.OSGIKillbillEventHandler getOSGIKillbillEventHandler();

    public OSGIKillbillEventDispatcher.OSGIFrameworkEventHandler getOSGIFrameworkEventHandler() {
        return null;
    }

    protected void configureSLF4JBinding() {
        try {
            Class<?> staticLoggerBinderClass = this.getClass().getClassLoader().loadClass("org.slf4j.impl.StaticLoggerBinder");
            Object staticLoggerBinder = staticLoggerBinderClass.getMethod("getSingleton", new Class[0]).invoke(null, new Object[0]);
            staticLoggerBinderClass.getMethod("setLogService", LogService.class).invoke(staticLoggerBinder, this.logService);
        }
        catch (ClassNotFoundException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs", e);
        }
        catch (InvocationTargetException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs", e);
        }
        catch (NoSuchMethodException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs");
        }
        catch (IllegalAccessException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs", e);
        }
    }
}

