/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.killbill.osgi.libs.killbill;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.killbill.osgi.libs.killbill.OSGIKillbillLibraryBase;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIKillbillEventDispatcher
extends OSGIKillbillLibraryBase {
    private final Logger logger = LoggerFactory.getLogger(OSGIKillbillEventDispatcher.class);
    private static final String OBSERVABLE_SERVICE_NAME = "java.util.Observable";
    private final ServiceTracker observableTracker;
    private final Map<Object, Observer> handlerToObserver = new HashMap<Object, Observer>();

    public OSGIKillbillEventDispatcher(BundleContext context) {
        this.observableTracker = new ServiceTracker(context, OBSERVABLE_SERVICE_NAME, null);
        this.observableTracker.open();
    }

    public void close() {
        if (this.observableTracker != null) {
            this.observableTracker.close();
        }
        this.handlerToObserver.clear();
    }

    public void registerEventHandler(final OSGIKillbillEventHandler handler) {
        Observer observer = new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(Observable o, Object arg) {
                if (!(arg instanceof ExtBusEvent)) {
                    OSGIKillbillEventDispatcher.this.logger.debug("OSGIKillbillEventDispatcher unexpected event type " + (arg != null ? arg.getClass() : "null"));
                    return;
                }
                ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
                try {
                    handler.handleKillbillEvent((ExtBusEvent)arg);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(initialContextClassLoader);
                }
            }
        };
        this.registerEventHandler(handler, observer);
    }

    public void registerEventHandler(final OSGIFrameworkEventHandler handler) {
        Observer observer = new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(Observable o, Object arg) {
                if (!(arg instanceof Event)) {
                    OSGIKillbillEventDispatcher.this.logger.debug("OSGIFrameworkEventHandler unexpected event type " + (arg != null ? arg.getClass() : "null"));
                    return;
                }
                String topic = ((Event)arg).getTopic();
                ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
                try {
                    if ("org/killbill/billing/osgi/lifecycle/STARTED".equals(topic)) {
                        handler.started();
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(initialContextClassLoader);
                }
            }
        };
        this.registerEventHandler(handler, observer);
    }

    public void registerEventHandler(final Object handler, final Observer observer) {
        this.withServiceTracker(this.observableTracker, new OSGIKillbillLibraryBase.APICallback<Void, Observable>(OBSERVABLE_SERVICE_NAME){

            @Override
            public Void executeWithService(Observable service) {
                OSGIKillbillEventDispatcher.this.handlerToObserver.put(handler, observer);
                service.addObserver(observer);
                return null;
            }
        });
    }

    public void unregisterEventHandler(final Object handler) {
        this.withServiceTracker(this.observableTracker, new OSGIKillbillLibraryBase.APICallback<Void, Observable>(OBSERVABLE_SERVICE_NAME){

            @Override
            public Void executeWithService(Observable service) {
                Observer observer = (Observer)OSGIKillbillEventDispatcher.this.handlerToObserver.get(handler);
                if (observer != null) {
                    service.deleteObserver(observer);
                    OSGIKillbillEventDispatcher.this.handlerToObserver.remove(handler);
                }
                return null;
            }
        });
    }

    public static interface OSGIFrameworkEventHandler {
        public void started();
    }

    public static interface OSGIKillbillEventHandler {
        public void handleKillbillEvent(ExtBusEvent var1);
    }
}

