/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.killbill.osgi.libs.killbill;

import javax.annotation.Nullable;
import org.killbill.killbill.osgi.libs.killbill.OSGIKillbillLibraryBase;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIKillbillLogService
extends OSGIKillbillLibraryBase
implements LogService {
    private static final String LOG_SERVICE_NAME = "org.osgi.service.log.LogService";
    private final ServiceTracker logTracker;

    public OSGIKillbillLogService(BundleContext context) {
        this.logTracker = new ServiceTracker(context, LOG_SERVICE_NAME, null);
        this.logTracker.open();
    }

    public void close() {
        if (this.logTracker != null) {
            this.logTracker.close();
        }
    }

    public void log(int level, String message) {
        this.logInternal(level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.logInternal(level, message, exception);
    }

    public void log(ServiceReference sr, int level, String message) {
        throw new UnsupportedOperationException();
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        throw new UnsupportedOperationException();
    }

    private void logInternal(final int level, final String message, final @Nullable Throwable t) {
        this.withServiceTracker(this.logTracker, new OSGIKillbillLibraryBase.APICallback<Void, LogService>(LOG_SERVICE_NAME){

            @Override
            public Void executeWithService(LogService service) {
                if (t == null) {
                    service.log(level, message);
                } else {
                    service.log(level, message, t);
                }
                return null;
            }

            @Override
            protected Void executeWithNoService() {
                if (level >= 2) {
                    System.out.println(message);
                } else {
                    System.err.println(message);
                }
                if (t != null) {
                    t.printStackTrace(System.err);
                }
                return null;
            }
        });
    }
}

