/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.libs.killbill;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.killbill.billing.osgi.api.OSGIKillbillRegistrar;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginConfigServiceApi;
import org.killbill.billing.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillClock;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillDataSource;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillEventDispatcher;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillLogService;
import org.killbill.billing.osgi.libs.killbill.OSGIServiceNotAvailable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public abstract class KillbillActivatorBase
implements BundleActivator {
    @Deprecated
    private static final String JRUBY_PLUGINS_RESTART_DELAY_SECS = "org.killbill.billing.osgi.bundles.jruby.restart.delay.secs";
    private static final String PLUGINS_RESTART_DELAY_SECS = "org.killbill.billing.osgi.bundles.restart.delay.secs";
    public static final String TMP_DIR_NAME = "tmp";
    public static final String RESTART_FILE_NAME = "restart.txt";
    public static final String DISABLED_FILE_NAME = "disabled.txt";
    protected OSGIKillbillAPI killbillAPI;
    protected OSGIKillbillLogService logService;
    protected OSGIKillbillRegistrar registrar;
    protected OSGIKillbillDataSource dataSource;
    protected OSGIKillbillClock clock;
    protected OSGIKillbillEventDispatcher dispatcher;
    protected OSGIConfigPropertiesService configProperties;
    protected File tmpDir = null;
    private ScheduledFuture<?> restartFuture = null;

    public void start(BundleContext context) throws Exception {
        this.logService = new OSGIKillbillLogService(context);
        this.logSafely(3, String.format("OSGI bundle='%s' received START command", context.getBundle().getSymbolicName()));
        this.killbillAPI = new OSGIKillbillAPI(context);
        this.configureSLF4JBinding();
        this.dataSource = new OSGIKillbillDataSource(context);
        this.dispatcher = new OSGIKillbillEventDispatcher(context);
        this.configProperties = new OSGIConfigPropertiesService(context);
        this.clock = new OSGIKillbillClock(context);
        this.registrar = new OSGIKillbillRegistrar();
        PluginConfig pluginConfig = this.retrievePluginConfig(context);
        this.tmpDir = this.setupTmpDir(pluginConfig);
        this.setupRestartMechanism(pluginConfig, context);
    }

    public void stop(BundleContext context) throws Exception {
        this.logSafely(3, String.format("OSGI bundle='%s' received STOP command", context.getBundle().getSymbolicName()));
        if (this.restartFuture != null) {
            this.restartFuture.cancel(true);
        }
        this.stopAllButRestartMechanism(context);
    }

    protected void stopAllButRestartMechanism(BundleContext context) throws Exception {
        if (this.registrar != null) {
            this.registrar.unregisterAll();
            this.registrar = null;
        }
        try {
            if (this.dispatcher != null) {
                this.dispatcher.unregisterAllHandlers();
            }
        }
        catch (OSGIServiceNotAvailable ignore) {
            this.logSafely(2, String.format("OSGI bundle='%s' failed to unregister killbill handler", context.getBundle().getSymbolicName()));
        }
        finally {
            if (this.dispatcher != null) {
                this.dispatcher.close();
                this.dispatcher = null;
            }
        }
        if (this.killbillAPI != null) {
            this.killbillAPI.close();
            this.killbillAPI = null;
        }
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
        if (this.logService != null) {
            this.logService.close();
            this.logService = null;
        }
    }

    protected void configureSLF4JBinding() {
        try {
            Class<?> staticLoggerBinderClass = this.getClass().getClassLoader().loadClass("org.slf4j.impl.StaticLoggerBinder");
            Object staticLoggerBinder = staticLoggerBinderClass.getMethod("getSingleton", new Class[0]).invoke(null, new Object[0]);
            staticLoggerBinderClass.getMethod("setLogService", LogService.class).invoke(staticLoggerBinder, this.logService);
        }
        catch (ClassNotFoundException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs", e);
        }
        catch (InvocationTargetException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs", e);
        }
        catch (NoSuchMethodException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs");
        }
        catch (IllegalAccessException e) {
            this.logService.log(2, "Unable to redirect SLF4J logs", e);
        }
    }

    protected PluginConfig retrievePluginConfig(BundleContext context) {
        PluginConfigServiceApi pluginConfigServiceApi = this.killbillAPI.getPluginConfigServiceApi();
        return pluginConfigServiceApi.getPluginJavaConfig(context.getBundle().getBundleId());
    }

    private void setupRestartMechanism(final PluginConfig pluginConfig, final BundleContext context) {
        if (this.tmpDir == null || this.restartFuture != null) {
            return;
        }
        String restartDelaySecProperty = this.configProperties.getString(JRUBY_PLUGINS_RESTART_DELAY_SECS);
        if (restartDelaySecProperty == null) {
            restartDelaySecProperty = this.configProperties.getString(PLUGINS_RESTART_DELAY_SECS);
        }
        Integer restartDelaySecs = restartDelaySecProperty == null ? 5 : Integer.parseInt(restartDelaySecProperty);
        this.restartFuture = Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(new Runnable(){
            long lastRestartMillis = System.currentTimeMillis();

            public void run() {
                boolean shouldStopPlugin = KillbillActivatorBase.this.shouldStopPlugin();
                if (shouldStopPlugin) {
                    try {
                        KillbillActivatorBase.this.logSafely(3, String.format("Stopping plugin='%s' ", pluginConfig.getPluginName()));
                        KillbillActivatorBase.this.stopAllButRestartMechanism(context);
                    }
                    catch (IllegalStateException e) {
                        KillbillActivatorBase.this.logSafely(4, String.format("Error stopping plugin='%s'", pluginConfig.getPluginName()), e);
                    }
                    catch (Exception e) {
                        KillbillActivatorBase.this.logSafely(2, String.format("Error stopping plugin='%s'", pluginConfig.getPluginName()), e);
                    }
                    return;
                }
                Long lastRestartTime = KillbillActivatorBase.this.lastRestartTime();
                if (lastRestartTime != null && lastRestartTime > this.lastRestartMillis) {
                    KillbillActivatorBase.this.logSafely(3, String.format("Restarting plugin='%s'", pluginConfig.getPluginName()));
                    try {
                        KillbillActivatorBase.this.stopAllButRestartMechanism(context);
                    }
                    catch (IllegalStateException e) {
                        KillbillActivatorBase.this.logSafely(4, String.format("Error stopping plugin='%s'", pluginConfig.getPluginName()), e);
                    }
                    catch (Exception e) {
                        KillbillActivatorBase.this.logSafely(2, String.format("Error stopping plugin='%s'", pluginConfig.getPluginName()), e);
                    }
                    try {
                        KillbillActivatorBase.this.start(context);
                    }
                    catch (Exception e) {
                        KillbillActivatorBase.this.logSafely(2, String.format("Error starting plugin='%s'", pluginConfig.getPluginName()), e);
                    }
                    this.lastRestartMillis = lastRestartTime;
                }
            }
        }, restartDelaySecs.intValue(), restartDelaySecs.intValue(), TimeUnit.SECONDS);
    }

    protected boolean shouldStopPlugin() {
        File stopFile = new File(this.tmpDir + "/" + DISABLED_FILE_NAME);
        return stopFile.isFile();
    }

    protected Long lastRestartTime() {
        File restartFile = new File(this.tmpDir + "/" + RESTART_FILE_NAME);
        if (!restartFile.isFile()) {
            return null;
        }
        return restartFile.lastModified();
    }

    private void logSafely(int level, String message) {
        if (this.logService != null) {
            this.logService.log(level, message);
        }
    }

    private void logSafely(int level, String message, Throwable exception) {
        if (this.logService != null) {
            this.logService.log(level, message, exception);
        }
    }

    private File setupTmpDir(PluginConfig pluginConfig) {
        File tmpDirPath = new File(pluginConfig.getPluginVersionRoot().getAbsolutePath() + "/" + TMP_DIR_NAME);
        if (!tmpDirPath.exists() && !tmpDirPath.mkdir()) {
            this.logService.log(2, "Unable to create directory " + tmpDirPath + ", the restart mechanism is disabled");
            return null;
        }
        if (!tmpDirPath.isDirectory()) {
            this.logService.log(2, tmpDirPath + " is not a directory, the restart mechanism is disabled");
            return null;
        }
        return tmpDirPath;
    }
}

