/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.libs.killbill;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillLibraryBase;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIKillbillEventDispatcher
extends OSGIKillbillLibraryBase {
    private final Logger logger = LoggerFactory.getLogger(OSGIKillbillEventDispatcher.class);
    private static final String OBSERVABLE_SERVICE_NAME = "java.util.Observable";
    private final ServiceTracker<Observable, Observable> observableTracker;
    private final Map<Object, Observer> handlerToObserver = new HashMap<Object, Observer>();

    public OSGIKillbillEventDispatcher(BundleContext context) {
        this.observableTracker = new ServiceTracker(context, OBSERVABLE_SERVICE_NAME, null);
        this.observableTracker.open();
    }

    public void close() {
        if (this.observableTracker != null) {
            this.observableTracker.close();
        }
        this.handlerToObserver.clear();
    }

    public void registerEventHandlers(OSGIHandlerMarker ... handlerOfSomeTypes) {
        for (OSGIHandlerMarker handlerOfSomeType : handlerOfSomeTypes) {
            this.registerEventHandler(handlerOfSomeType);
        }
    }

    private void registerEventHandler(final OSGIHandlerMarker handlerOfSomeType) {
        Observer observer = new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(Observable o, Object arg) {
                ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(handlerOfSomeType.getClass().getClassLoader());
                try {
                    if (handlerOfSomeType instanceof OSGIKillbillEventHandler) {
                        this.handleKillbillEvent((OSGIKillbillEventHandler)handlerOfSomeType, arg);
                    } else if (handlerOfSomeType instanceof OSGIFrameworkEventHandler) {
                        this.handleOSGIStartEvent((OSGIFrameworkEventHandler)handlerOfSomeType, arg);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(initialContextClassLoader);
                }
            }

            private void handleKillbillEvent(OSGIKillbillEventHandler handler, Object arg) {
                if (!(arg instanceof ExtBusEvent)) {
                    OSGIKillbillEventDispatcher.this.logger.debug("OSGIKillbillEventDispatcher unexpected event type " + (arg != null ? arg.getClass() : "null"));
                    return;
                }
                handler.handleKillbillEvent((ExtBusEvent)arg);
            }

            private void handleOSGIStartEvent(OSGIFrameworkEventHandler handler, Object arg) {
                if (!(arg instanceof Event)) {
                    OSGIKillbillEventDispatcher.this.logger.debug("OSGIFrameworkEventHandler unexpected event type " + (arg != null ? arg.getClass() : "null"));
                    return;
                }
                String topic = ((Event)arg).getTopic();
                if ("org/killbill/billing/osgi/lifecycle/STARTED".equals(topic)) {
                    handler.started();
                }
            }
        };
        this.registerEventHandler(handlerOfSomeType, observer);
    }

    public void registerEventHandler(final OSGIHandlerMarker handler, final Observer observer) {
        this.withServiceTracker(this.observableTracker, new OSGIKillbillLibraryBase.APICallback<Void, Observable>(OBSERVABLE_SERVICE_NAME){

            @Override
            public Void executeWithService(Observable service) {
                OSGIKillbillEventDispatcher.this.handlerToObserver.put(handler, observer);
                service.addObserver(observer);
                return null;
            }
        });
    }

    public void unregisterEventHandler(final OSGIHandlerMarker handler) {
        this.withServiceTracker(this.observableTracker, new OSGIKillbillLibraryBase.APICallback<Void, Observable>(OBSERVABLE_SERVICE_NAME){

            @Override
            public Void executeWithService(Observable service) {
                Observer observer = (Observer)OSGIKillbillEventDispatcher.this.handlerToObserver.get(handler);
                if (observer != null) {
                    service.deleteObserver(observer);
                    OSGIKillbillEventDispatcher.this.handlerToObserver.remove(handler);
                }
                return null;
            }
        });
    }

    public void unregisterAllHandlers() {
        this.withServiceTracker(this.observableTracker, new OSGIKillbillLibraryBase.APICallback<Void, Observable>(OBSERVABLE_SERVICE_NAME){

            @Override
            public Void executeWithService(Observable service) {
                for (Object handler : OSGIKillbillEventDispatcher.this.handlerToObserver.keySet()) {
                    Observer observer = (Observer)OSGIKillbillEventDispatcher.this.handlerToObserver.get(handler);
                    if (observer == null) continue;
                    service.deleteObserver(observer);
                }
                OSGIKillbillEventDispatcher.this.handlerToObserver.clear();
                return null;
            }
        });
    }

    public static interface OSGIFrameworkEventHandler
    extends OSGIHandlerMarker {
        public void started();
    }

    public static interface OSGIKillbillEventHandler
    extends OSGIHandlerMarker {
        public void handleKillbillEvent(ExtBusEvent var1);
    }

    public static interface OSGIHandlerMarker {
    }
}

