/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.libs.killbill;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.killbill.billing.osgi.libs.killbill.KillbillServiceListenerCallback;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class KillbillServiceListener
implements ServiceListener {
    private final BundleContext context;
    private final KillbillServiceListenerCallback killbillServiceListenerCallback;

    public static KillbillServiceListener listenForService(BundleContext context, String serviceClass, KillbillServiceListenerCallback listenerCallback) throws InvalidSyntaxException {
        String filter = "(objectclass=" + serviceClass + ")";
        KillbillServiceListener killbillServiceListener = new KillbillServiceListener(context, listenerCallback);
        context.addServiceListener((ServiceListener)killbillServiceListener, filter);
        ServiceReference[] serviceReferences = context.getServiceReferences((String)null, filter);
        for (int i = 0; serviceReferences != null && i < serviceReferences.length; ++i) {
            killbillServiceListener.serviceChanged(new ServiceEvent(1, serviceReferences[i]));
        }
        return killbillServiceListener;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public KillbillServiceListener(BundleContext context, KillbillServiceListenerCallback killbillServiceListenerCallback) {
        this.context = context;
        this.killbillServiceListenerCallback = killbillServiceListenerCallback;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceReference = event.getServiceReference();
        if (serviceReference == null || serviceReference.getBundle() == null) {
            return;
        }
        BundleContext bundleContext = serviceReference.getBundle().getBundleContext();
        if (bundleContext == null) {
            return;
        }
        Object service = bundleContext.getService(serviceReference);
        if (service != null) {
            if (event.getType() == 1) {
                this.killbillServiceListenerCallback.isRegistered(this.context);
            } else if (event.getType() == 4) {
                this.killbillServiceListenerCallback.isUnRegistering(this.context);
            }
        }
    }
}

