/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.libs.killbill;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.killbill.billing.osgi.api.OSGIKillbillRegistrar;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginConfigServiceApi;
import org.killbill.billing.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillClock;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillDataSource;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillEventDispatcher;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillLogService;
import org.killbill.billing.osgi.libs.killbill.OSGIMetricRegistry;
import org.killbill.billing.osgi.libs.killbill.OSGIServiceNotAvailable;
import org.killbill.billing.osgi.libs.killbill.ROOSGIKillbillAPI;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KillbillActivatorBase
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(KillbillActivatorBase.class);
    private ScheduledExecutorService restartMechanismExecutorService = null;
    private static final String PLUGINS_RESTART_DELAY_SECS = "org.killbill.billing.osgi.bundles.restart.delay.secs";
    public static final String TMP_DIR_NAME = "tmp";
    public static final String RESTART_FILE_NAME = "restart.txt";
    public static final String DISABLED_FILE_NAME = "disabled.txt";
    protected OSGIKillbillAPI killbillAPI;
    protected ROOSGIKillbillAPI roOSGIkillbillAPI;
    protected OSGIKillbillLogService logService;
    protected OSGIKillbillRegistrar registrar;
    protected OSGIKillbillDataSource dataSource;
    protected OSGIKillbillClock clock;
    protected OSGIKillbillEventDispatcher dispatcher;
    protected OSGIConfigPropertiesService configProperties;
    protected OSGIMetricRegistry metricRegistry;
    protected File tmpDir = null;
    private ScheduledFuture<?> restartFuture = null;

    public void start(BundleContext context) throws Exception {
        this.logService = new OSGIKillbillLogService(context);
        logger.info("OSGI bundle='{}' received START command", (Object)context.getBundle().getSymbolicName());
        this.killbillAPI = new OSGIKillbillAPI(context);
        this.roOSGIkillbillAPI = new ROOSGIKillbillAPI(context);
        this.dataSource = new OSGIKillbillDataSource(context);
        this.dispatcher = new OSGIKillbillEventDispatcher(context);
        this.configProperties = new OSGIConfigPropertiesService(context);
        this.clock = new OSGIKillbillClock(context);
        this.metricRegistry = new OSGIMetricRegistry(context);
        this.registrar = new OSGIKillbillRegistrar();
        PluginConfig pluginConfig = this.retrievePluginConfig(context);
        if (pluginConfig != null) {
            this.tmpDir = this.setupTmpDir(pluginConfig);
            this.setupRestartMechanism(pluginConfig, context);
        }
    }

    public void stop(BundleContext context) throws Exception {
        logger.info("OSGI bundle='{}' received STOP command", (Object)context.getBundle().getSymbolicName());
        if (this.restartFuture != null) {
            this.restartFuture.cancel(true);
        }
        if (this.restartMechanismExecutorService != null) {
            this.restartMechanismExecutorService.shutdownNow();
        }
        this.stopAllButRestartMechanism(context);
    }

    protected void stopAllButRestartMechanism(BundleContext context) throws Exception {
        if (this.registrar != null) {
            this.registrar.unregisterAll();
            this.registrar = null;
        }
        try {
            if (this.dispatcher != null) {
                this.dispatcher.unregisterAllHandlers();
            }
        }
        catch (OSGIServiceNotAvailable ignore) {
            logger.warn("OSGI bundle='{}' failed to unregister killbill handler", (Object)context.getBundle().getSymbolicName());
        }
        finally {
            if (this.dispatcher != null) {
                this.dispatcher.close();
                this.dispatcher = null;
            }
        }
        if (this.killbillAPI != null) {
            this.killbillAPI.close();
            this.killbillAPI = null;
        }
        if (this.roOSGIkillbillAPI != null) {
            this.roOSGIkillbillAPI.close();
            this.roOSGIkillbillAPI = null;
        }
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
        if (this.logService != null) {
            this.logService.close();
            this.logService = null;
        }
    }

    protected PluginConfig retrievePluginConfig(BundleContext context) {
        PluginConfigServiceApi pluginConfigServiceApi = this.killbillAPI.getPluginConfigServiceApi();
        return pluginConfigServiceApi.getPluginJavaConfig(context.getBundle().getBundleId());
    }

    private void setupRestartMechanism(final PluginConfig pluginConfig, final BundleContext context) {
        if (this.tmpDir == null || this.restartFuture != null) {
            return;
        }
        String restartDelaySecProperty = this.configProperties.getString(PLUGINS_RESTART_DELAY_SECS);
        Integer restartDelaySecs = restartDelaySecProperty == null ? 5 : Integer.parseInt(restartDelaySecProperty);
        this.restartMechanismExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.restartFuture = this.restartMechanismExecutorService.scheduleWithFixedDelay(new Runnable(){
            long lastRestartMillis = System.currentTimeMillis();

            @Override
            public void run() {
                boolean shouldStopPlugin = KillbillActivatorBase.this.shouldStopPlugin();
                if (shouldStopPlugin) {
                    try {
                        logger.info("Stopping plugin='{}' ", (Object)pluginConfig.getPluginName());
                        KillbillActivatorBase.this.stopAllButRestartMechanism(context);
                    }
                    catch (Exception e) {
                        logger.warn("Error stopping plugin='{}'", (Object)pluginConfig.getPluginName(), (Object)e);
                    }
                    return;
                }
                Long lastRestartTime = KillbillActivatorBase.this.lastRestartTime();
                if (lastRestartTime != null && lastRestartTime > this.lastRestartMillis) {
                    logger.info("Restarting plugin='{}'", (Object)pluginConfig.getPluginName());
                    try {
                        KillbillActivatorBase.this.stopAllButRestartMechanism(context);
                    }
                    catch (Exception e) {
                        logger.warn("Error stopping plugin='{}'", (Object)pluginConfig.getPluginName(), (Object)e);
                    }
                    try {
                        KillbillActivatorBase.this.start(context);
                    }
                    catch (Exception e) {
                        logger.warn("Error starting plugin='{}'", (Object)pluginConfig.getPluginName(), (Object)e);
                    }
                    this.lastRestartMillis = lastRestartTime;
                }
            }
        }, restartDelaySecs.intValue(), restartDelaySecs.intValue(), TimeUnit.SECONDS);
    }

    protected boolean shouldStopPlugin() {
        File stopFile = new File(this.tmpDir + "/disabled.txt");
        return stopFile.isFile();
    }

    protected Long lastRestartTime() {
        File restartFile = new File(this.tmpDir + "/restart.txt");
        if (!restartFile.isFile()) {
            return null;
        }
        return restartFile.lastModified();
    }

    private File setupTmpDir(PluginConfig pluginConfig) {
        File tmpDirPath = new File(pluginConfig.getPluginVersionRoot().getAbsolutePath() + "/tmp");
        if (!tmpDirPath.exists() && !tmpDirPath.mkdir()) {
            logger.warn("Unable to create directory {}, the restart mechanism is disabled", (Object)tmpDirPath);
            return null;
        }
        if (!tmpDirPath.isDirectory()) {
            logger.warn("{} is not a directory, the restart mechanism is disabled", (Object)tmpDirPath);
            return null;
        }
        return tmpDirPath;
    }
}

