/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextClassLoaderHelper {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    public static <T> T getWrappedServiceWithCorrectContextClassLoader(T service, Class<T> serviceType, String serviceName, @Nullable MetricRegistry metricRegistry) {
        Class<?> serviceClass = service.getClass();
        List<Class> allServiceInterfaces = ContextClassLoaderHelper.getAllInterfaces(serviceClass);
        Class[] serviceClassInterfaces = allServiceInterfaces.toArray(new Class[allServiceInterfaces.size()]);
        ClassLoaderInvocationHandler<T> handler = new ClassLoaderInvocationHandler<T>(service, serviceName, serviceType, metricRegistry);
        Object wrappedService = Proxy.newProxyInstance(serviceClass.getClassLoader(), serviceClassInterfaces, handler);
        return (T)wrappedService;
    }

    private static List<Class> getAllInterfaces(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList<Class> list = new ArrayList<Class>();
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
                if (!list.contains(anInterface)) {
                    list.add(anInterface);
                }
                List<Class> superInterfaces = ContextClassLoaderHelper.getAllInterfaces(anInterface);
                for (Class superInterface : superInterfaces) {
                    Class intface = superInterface;
                    if (list.contains(intface)) continue;
                    list.add(intface);
                }
            }
            cls = cls.getSuperclass();
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassLoaderInvocationHandler<T>
    extends AbstractInvocationHandler {
        private final String serviceName;
        private final T service;
        private final Class<?> serviceClass;
        private final String serviceInterfaceName;
        private final MetricRegistry metricRegistry;
        private LoadingCache<String, Timer> timerMetricCache;
        private LoadingCache<String, Meter> errorMetricCache;

        public ClassLoaderInvocationHandler(T service, String serviceName, Class<T> serviceInterface, MetricRegistry metricRegistry) {
            this.service = service;
            this.serviceName = serviceName;
            this.metricRegistry = metricRegistry;
            this.serviceClass = service.getClass();
            this.serviceInterfaceName = serviceInterface.getSimpleName();
            this.initializeMetricCaches();
        }

        protected Object handleInvocation(Object proxy, final Method method, final Object[] args) throws Throwable {
            ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
            Timer.Context timerContext = this.timer(method).time();
            try {
                Thread.currentThread().setContextClassLoader(this.serviceClass.getClassLoader());
                String methodName = method.getName();
                Profiling prof = new Profiling();
                String profilingId = this.serviceInterfaceName + "." + methodName;
                Object object = prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.PLUGIN, profilingId, (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

                    public Object execute() throws Throwable {
                        return method.invoke(ClassLoaderInvocationHandler.this.service, args);
                    }
                });
                return object;
            }
            catch (InvocationTargetException e) {
                Meter errors = this.errorMeter(method);
                errors.mark();
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw new RuntimeException(e);
            }
            finally {
                timerContext.stop();
                Thread.currentThread().setContextClassLoader(initialContextClassLoader);
            }
        }

        private Timer timer(Method method) {
            return (Timer)this.timerMetricCache.getUnchecked((Object)method.getName());
        }

        private Meter errorMeter(Method method) {
            return (Meter)this.errorMetricCache.getUnchecked((Object)method.getName());
        }

        private void initializeMetricCaches() {
            this.timerMetricCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Timer>(){

                public Timer load(String methodName) {
                    String timerMetricName = DOT_JOINER.join((Object)"killbill-service", (Object)"kb_plugin_latency", new Object[]{ClassLoaderInvocationHandler.this.serviceName, ClassLoaderInvocationHandler.this.serviceInterfaceName, methodName});
                    return ClassLoaderInvocationHandler.this.metricRegistry.timer(timerMetricName);
                }
            });
            this.errorMetricCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Meter>(){

                public Meter load(String methodName) {
                    String counterMetricName = DOT_JOINER.join((Object)"killbill-service", (Object)"kb_plugin_errors", new Object[]{ClassLoaderInvocationHandler.this.serviceName, ClassLoaderInvocationHandler.this.serviceInterfaceName, methodName});
                    return ClassLoaderInvocationHandler.this.metricRegistry.meter(counterMetricName);
                }
            });
        }
    }
}

