/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRubyJarHelper {
    private static final Logger logger = LoggerFactory.getLogger(JRubyJarHelper.class);
    static final String POM_PROPERTIES = "META-INF/maven/org.kill-bill.billing/killbill-platform-osgi-bundles-jruby/pom.properties";
    private final KillbillNodesApi nodesApi;
    private final String jrubyJarPath;

    public JRubyJarHelper(String platformOSGIBundlesRootDir, @Nullable KillbillNodesApi nodesApi) {
        this.jrubyJarPath = platformOSGIBundlesRootDir + "jruby.jar";
        this.nodesApi = nodesApi;
    }

    public String getAndValidateJrubyJarPath() {
        if (new File(this.jrubyJarPath).isFile()) {
            this.logIfVersionMismatch();
            return this.jrubyJarPath;
        }
        logger.warn("Unable to find the JRuby bundle at {}, ruby plugins won't be started!", (Object)this.jrubyJarPath);
        return null;
    }

    private void logIfVersionMismatch() {
        try {
            NodeInfo nodeInfo;
            NodeInfo nodeInfo2 = nodeInfo = this.nodesApi == null ? null : this.nodesApi.getCurrentNodeInfo();
            if (nodeInfo == null) {
                logger.warn("Failed to get current NodeInfo to validate jruby.jar {}", (Object)this.jrubyJarPath);
                return;
            }
            String platformVersion = nodeInfo.getPlatformVersion();
            Properties properties = this.getProperties(this.jrubyJarPath, POM_PROPERTIES);
            String jrubyJarVersion = this.extractVersion(properties);
            if (jrubyJarVersion == null) {
                logger.warn("Failed to extract jruby.jar version from file {}", (Object)this.jrubyJarPath);
                return;
            }
            if (!jrubyJarVersion.equals(platformVersion)) {
                logger.warn("Detected version mismatch between existing jruby.jar [version={}] and platform [version={}]", (Object)jrubyJarVersion, (Object)platformVersion);
                return;
            }
        }
        catch (IOException e) {
            logger.warn("Failed to validate jruby.jar version:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String jarFileName, String entryName) throws IOException {
        InputStream stream = null;
        Reader reader = null;
        try {
            JarFile jarFile = new JarFile(jarFileName);
            ZipEntry entry = jarFile.getEntry(entryName);
            stream = jarFile.getInputStream(entry);
            reader = new InputStreamReader(stream, Charsets.UTF_8);
            Properties props = new Properties();
            props.load(reader);
            Properties properties = props;
            return properties;
        }
        finally {
            IOException streamIOException = null;
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    streamIOException = ioe;
                }
            }
            if (reader != null) {
                reader.close();
            }
            if (streamIOException != null) {
                throw streamIOException;
            }
        }
    }

    @VisibleForTesting
    String extractVersion(Properties properties) {
        return (String)properties.get("version");
    }
}

