/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Inject;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.killbill.billing.catalog.plugin.api.CatalogPluginApi;
import org.killbill.billing.control.plugin.api.PaymentControlPluginApi;
import org.killbill.billing.currency.plugin.api.CurrencyPluginApi;
import org.killbill.billing.entitlement.plugin.api.EntitlementPluginApi;
import org.killbill.billing.invoice.plugin.api.InvoicePluginApi;
import org.killbill.billing.osgi.BundleRegistry;
import org.killbill.billing.osgi.ContextClassLoaderHelper;
import org.killbill.billing.osgi.DefaultOSGIServiceDescriptor;
import org.killbill.billing.osgi.KillbillEventObservable;
import org.killbill.billing.osgi.KillbillEventRetriableBusHandler;
import org.killbill.billing.osgi.api.Healthcheck;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.api.OSGIKillbill;
import org.killbill.billing.osgi.api.OSGIKillbillRegistrar;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.platform.jndi.JNDIManager;
import org.killbill.clock.Clock;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillbillActivator
implements BundleActivator,
ServiceListener {
    static final int PLUGIN_NAME_MAX_LENGTH = 40;
    static final Pattern PLUGIN_NAME_PATTERN = Pattern.compile("\\p{Lower}(?:\\p{Lower}|\\d|-|_)*");
    private static final Logger logger = LoggerFactory.getLogger(KillbillActivator.class);
    private static final String KILLBILL_OSGI_JDBC_JNDI_NAME = "killbill/osgi/jdbc";
    private final OSGIKillbill osgiKillbill;
    private final HttpService defaultHttpService;
    private final DataSource dataSource;
    private final Clock clock;
    private final KillbillEventRetriableBusHandler killbillEventRetriableBusHandler;
    private final KillbillEventObservable observable;
    private final OSGIKillbillRegistrar registrar;
    private final OSGIConfigProperties configProperties;
    private final JNDIManager jndiManager;
    private final MetricRegistry metricsRegistry;
    private final BundleRegistry bundleRegistry;
    private final List<OSGIServiceRegistration> allRegistrationHandlers;
    private BundleContext context = null;

    @Inject
    public KillbillActivator(@Named(value="osgi") DataSource dataSource, OSGIKillbill osgiKillbill, Clock clock, BundleRegistry bundleRegistry, HttpService defaultHttpService, KillbillEventRetriableBusHandler killbillEventRetriableBusHandler, KillbillEventObservable observable, OSGIConfigProperties configProperties, MetricRegistry metricsRegistry, JNDIManager jndiManager) {
        this.osgiKillbill = osgiKillbill;
        this.bundleRegistry = bundleRegistry;
        this.defaultHttpService = defaultHttpService;
        this.dataSource = dataSource;
        this.clock = clock;
        this.killbillEventRetriableBusHandler = killbillEventRetriableBusHandler;
        this.observable = observable;
        this.configProperties = configProperties;
        this.jndiManager = jndiManager;
        this.metricsRegistry = metricsRegistry;
        this.registrar = new OSGIKillbillRegistrar();
        this.allRegistrationHandlers = new LinkedList<OSGIServiceRegistration>();
    }

    @Inject(optional=true)
    public void addServletOSGIServiceRegistration(OSGIServiceRegistration<Servlet> servletRouter) {
        this.allRegistrationHandlers.add(servletRouter);
    }

    @Inject(optional=true)
    public void addPaymentPluginApiOSGIServiceRegistration(OSGIServiceRegistration<PaymentPluginApi> paymentProviderPluginRegistry) {
        this.allRegistrationHandlers.add(paymentProviderPluginRegistry);
    }

    @Inject(optional=true)
    public void addInvoicePluginApiOSGIServiceRegistration(OSGIServiceRegistration<InvoicePluginApi> invoiceProviderPluginRegistry) {
        this.allRegistrationHandlers.add(invoiceProviderPluginRegistry);
    }

    @Inject(optional=true)
    public void addCurrencyPluginApiOSGIServiceRegistration(OSGIServiceRegistration<CurrencyPluginApi> currencyProviderPluginRegistry) {
        this.allRegistrationHandlers.add(currencyProviderPluginRegistry);
    }

    @Inject(optional=true)
    public void addPaymentControlPluginApiOSGIServiceRegistration(OSGIServiceRegistration<PaymentControlPluginApi> paymentControlProviderPluginRegistry) {
        this.allRegistrationHandlers.add(paymentControlProviderPluginRegistry);
    }

    @Inject(optional=true)
    public void addCatalogPluginApiOSGIServiceRegistration(OSGIServiceRegistration<CatalogPluginApi> catalogProviderPluginRegistry) {
        this.allRegistrationHandlers.add(catalogProviderPluginRegistry);
    }

    @Inject(optional=true)
    public void addEntitlementPluginApiOSGIServiceRegistration(OSGIServiceRegistration<EntitlementPluginApi> entitlementProviderPluginRegistry) {
        this.allRegistrationHandlers.add(entitlementProviderPluginRegistry);
    }

    @Inject(optional=true)
    public void addHealthcheckOSGIServiceRegistration(OSGIServiceRegistration<Healthcheck> healthcheckRegistry) {
        this.allRegistrationHandlers.add(healthcheckRegistry);
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("killbill.pluginName", "killbill");
        this.killbillEventRetriableBusHandler.register();
        this.registrar.registerService(context, OSGIKillbill.class, (Object)this.osgiKillbill, props);
        this.registrar.registerService(context, HttpService.class, (Object)this.defaultHttpService, props);
        this.registrar.registerService(context, Observable.class, (Object)this.observable, props);
        this.registrar.registerService(context, DataSource.class, (Object)this.dataSource, props);
        this.registrar.registerService(context, OSGIConfigProperties.class, (Object)this.configProperties, props);
        this.registrar.registerService(context, Clock.class, (Object)this.clock, props);
        context.addServiceListener((ServiceListener)this);
        this.jndiManager.export(KILLBILL_OSGI_JDBC_JNDI_NAME, (Object)this.dataSource);
    }

    public void stop(BundleContext context) throws Exception {
        this.jndiManager.unExport(KILLBILL_OSGI_JDBC_JNDI_NAME);
        this.context = null;
        context.removeServiceListener((ServiceListener)this);
        this.killbillEventRetriableBusHandler.unregister();
        this.registrar.unregisterAll();
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.context == null || event.getType() != 1 && event.getType() != 4) {
            return;
        }
        ServiceReference serviceReference = event.getServiceReference();
        for (OSGIServiceRegistration cur : this.allRegistrationHandlers) {
            if (!this.listenForServiceType(serviceReference, event.getType(), cur.getServiceType(), cur)) continue;
            break;
        }
    }

    public void sendEvent(String topic, Map<String, String> properties) {
        this.observable.setChangedAndNotifyObservers(new Event(topic, properties));
    }

    public List<OSGIServiceRegistration> getAllRegistrationHandlers() {
        return this.allRegistrationHandlers;
    }

    private <T> boolean listenForServiceType(ServiceReference<?> serviceReference, int eventType, Class<T> claz, OSGIServiceRegistration<T> registration) {
        String serviceName = (String)serviceReference.getProperty("killbill.pluginName");
        if (serviceName == null || !this.checkSanityPluginRegistrationName(serviceName)) {
            logger.debug("Ignoring registered OSGI service {} with no {} property", (Object)claz.getName(), (Object)"killbill.pluginName");
            return true;
        }
        Object theServiceObject = this.context.getService(serviceReference);
        if (theServiceObject == null || !claz.isAssignableFrom(theServiceObject.getClass())) {
            return false;
        }
        Object theService = theServiceObject;
        DefaultOSGIServiceDescriptor desc = new DefaultOSGIServiceDescriptor(serviceReference.getBundle().getSymbolicName(), this.bundleRegistry.getPluginName(serviceReference.getBundle()), serviceName);
        switch (eventType) {
            case 1: {
                Object wrappedService = ContextClassLoaderHelper.getWrappedServiceWithCorrectContextClassLoader(theService, registration.getServiceType(), serviceName, this.metricsRegistry);
                registration.registerService((OSGIServiceDescriptor)desc, wrappedService);
                this.bundleRegistry.registerService(desc, registration.getServiceType().getName());
                break;
            }
            case 4: {
                registration.unregisterService(desc.getRegistrationName());
                this.bundleRegistry.unregisterService(desc, registration.getServiceType().getName());
                break;
            }
        }
        return true;
    }

    private boolean checkSanityPluginRegistrationName(String pluginName) {
        Matcher m = PLUGIN_NAME_PATTERN.matcher(pluginName);
        if (!m.matches()) {
            logger.warn("Invalid plugin name {} : should be of the form {}", (Object)pluginName, (Object)PLUGIN_NAME_PATTERN.toString());
            return false;
        }
        if (pluginName.length() > 40) {
            logger.warn("Invalid plugin name {} : too long, should be less than {}", (Object)pluginName, (Object)40);
            return false;
        }
        return true;
    }
}

