/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.pluginconf;

import java.io.File;
import java.util.Properties;
import org.killbill.billing.osgi.api.config.PluginJavaConfig;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.pluginconf.DefaultPluginConfig;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;

public class DefaultPluginJavaConfig
extends DefaultPluginConfig
implements PluginJavaConfig {
    private final String bundleJarPath;

    public DefaultPluginJavaConfig(DefaultPluginJavaConfig input, boolean isSelectedForStart) throws PluginConfigException {
        super(input, isSelectedForStart);
        this.bundleJarPath = input.getBundleJarPath();
    }

    public DefaultPluginJavaConfig(String pluginKey, String pluginName, String version, File pluginVersionRoot, Properties props, boolean isVersionTostartLink, boolean isDisabled) throws PluginConfigException {
        super(pluginKey, pluginName, version, props, pluginVersionRoot, isVersionTostartLink, isDisabled);
        this.bundleJarPath = this.extractJarPath(pluginVersionRoot);
        this.validate();
    }

    private String extractJarPath(File pluginVersionRoot) {
        File[] files = pluginVersionRoot.listFiles();
        if (files == null) {
            return null;
        }
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    public String getBundleJarPath() {
        return this.bundleJarPath;
    }

    public PluginLanguage getPluginLanguage() {
        return PluginLanguage.JAVA;
    }

    protected void validate() throws PluginConfigException {
        if (this.bundleJarPath == null) {
            throw new PluginConfigException("Invalid plugin " + this.getPluginVersionnedName() + ": cannot find jar file");
        }
    }
}

