/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.felix.framework.Felix;
import org.killbill.billing.osgi.BundleRegistry;
import org.killbill.billing.osgi.BundleWithConfig;
import org.killbill.billing.osgi.KillbillActivator;
import org.killbill.billing.osgi.OSGIListener;
import org.killbill.billing.osgi.config.OSGIConfig;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.billing.platform.api.OSGIService;
import org.killbill.bus.api.PersistentBus;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOSGIService
implements OSGIService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOSGIService.class);
    private final OSGIConfig osgiConfig;
    private final KillbillActivator killbillActivator;
    private final BundleRegistry bundleRegistry;
    private final List<BundleWithConfig> installedBundles;
    private final PersistentBus externalBus;
    private final OSGIListener osgiListener;
    private Framework framework;

    @Inject
    public DefaultOSGIService(OSGIConfig osgiConfig, BundleRegistry bundleRegistry, KillbillActivator killbillActivator, @Named(value="externalBus") PersistentBus externalBus, OSGIListener osgiListener) {
        this.osgiConfig = osgiConfig;
        this.killbillActivator = killbillActivator;
        this.bundleRegistry = bundleRegistry;
        this.externalBus = externalBus;
        this.osgiListener = osgiListener;
        this.installedBundles = new LinkedList<BundleWithConfig>();
        this.framework = null;
    }

    public String getName() {
        return KillbillService.KILLBILL_SERVICES.OSGI_SERVICE.getServiceName();
    }

    public int getRegistrationOrdering() {
        return KillbillService.KILLBILL_SERVICES.OSGI_SERVICE.getRegistrationOrdering();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_PLUGIN)
    public void initialize() {
        try {
            this.pruneOSGICache();
            this.framework = this.createAndInitFramework();
            this.framework.start();
            this.bundleRegistry.installBundles(this.framework);
            this.externalBus.register((Object)this.osgiListener);
        }
        catch (BundleException e) {
            logger.error("Failed to initialize Killbill OSGIService", (Throwable)e);
        }
        catch (PersistentBus.EventBusException e) {
            logger.error("Failed to initialize Killbill OSGIService", (Throwable)e);
        }
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.START_PLUGIN)
    public void start() {
        this.bundleRegistry.startBundles();
        this.killbillActivator.sendEvent("org/killbill/billing/osgi/lifecycle/STARTED", new HashMap<String, String>());
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_PLUGIN)
    public void stop() {
        try {
            this.externalBus.unregister((Object)this.osgiListener);
            this.framework.stop();
            this.framework.waitForStop(0L);
            this.installedBundles.clear();
            this.bundleRegistry.stopBundles();
            this.killbillActivator.sendEvent("org/killbill/billing/osgi/lifecycle/STOPPED", new HashMap<String, String>());
        }
        catch (BundleException e) {
            logger.error("Failed to Stop Killbill OSGIService " + e.getMessage());
        }
        catch (InterruptedException e) {
            logger.error("Failed to Stop Killbill OSGIService " + e.getMessage());
        }
        catch (PersistentBus.EventBusException e) {
            logger.error("Failed to Stop Killbill OSGIService " + e.getMessage());
        }
    }

    public List<BundleWithConfig> getInstalledBundles() {
        return this.installedBundles;
    }

    private Framework createAndInitFramework() throws BundleException {
        StringBuilder systemExtraPackages = new StringBuilder(this.osgiConfig.getSystemBundleExportPackagesApi());
        if (!this.osgiConfig.getSystemBundleExportPackagesJava().isEmpty()) {
            systemExtraPackages.append(",").append(this.osgiConfig.getSystemBundleExportPackagesJava());
        }
        if (!this.osgiConfig.getSystemBundleExportPackagesExtra().isEmpty()) {
            systemExtraPackages.append(",").append(this.osgiConfig.getSystemBundleExportPackagesExtra());
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.osgi.framework.system.packages.extra", systemExtraPackages.toString());
        config.put("felix.cache.rootdir", this.osgiConfig.getOSGIBundleRootDir());
        config.put("org.osgi.framework.storage", this.osgiConfig.getOSGIBundleCacheName());
        return this.createAndInitFelixFrameworkWithSystemBundle(config);
    }

    private Framework createAndInitFelixFrameworkWithSystemBundle(Map<String, String> config) throws BundleException {
        HashMap<String, String> felixConfig = new HashMap<String, String>();
        felixConfig.putAll(config);
        felixConfig.put("felix.systembundle.activators", (String)ImmutableList.of((Object)this.killbillActivator));
        Felix felix = new Felix(felixConfig);
        felix.init();
        return felix;
    }

    private void pruneOSGICache() {
        String path = this.osgiConfig.getOSGIBundleRootDir();
        DefaultOSGIService.deleteUnderDirectory(new File(path));
    }

    private static void deleteUnderDirectory(File path) {
        DefaultOSGIService.deleteDirectory(path, false);
    }

    private static void deleteDirectory(File path, boolean deleteParent) {
        if (path == null) {
            return;
        }
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        DefaultOSGIService.deleteDirectory(f, true);
                        continue;
                    }
                    if (f.delete()) continue;
                    logger.warn("Unable to delete {}", (Object)f.getAbsolutePath());
                }
            }
            if (deleteParent) {
                if (!path.delete()) {
                    logger.warn("Unable to delete {}", (Object)path.getAbsolutePath());
                } else {
                    logger.info("Deleted recursively {}", (Object)path.getAbsolutePath());
                }
            }
        }
    }
}

