/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.osgi.BundleWithConfig;
import org.killbill.billing.osgi.JRubyJarHelper;
import org.killbill.billing.osgi.PureOSGIBundleFinder;
import org.killbill.billing.osgi.api.KillbillNodesApiHolder;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginConfigServiceApi;
import org.killbill.billing.osgi.api.config.PluginJavaConfig;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.api.config.PluginRubyConfig;
import org.killbill.billing.osgi.pluginconf.DefaultPluginConfigServiceApi;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;
import org.killbill.billing.osgi.pluginconf.PluginFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInstall {
    private static final Logger logger = LoggerFactory.getLogger(FileInstall.class);
    private final PureOSGIBundleFinder osgiBundleFinder;
    private final PluginFinder pluginFinder;
    private final PluginConfigServiceApi pluginConfigServiceApi;
    private final AtomicInteger jrubyUniqueIndex;
    private final JRubyJarHelper jRubyJarHelper;

    @Inject
    public FileInstall(PureOSGIBundleFinder osgiBundleFinder, PluginFinder pluginFinder, KillbillNodesApiHolder nodesApiHolder, PluginConfigServiceApi pluginConfigServiceApi) {
        this.osgiBundleFinder = osgiBundleFinder;
        this.pluginFinder = pluginFinder;
        this.pluginConfigServiceApi = pluginConfigServiceApi;
        this.jRubyJarHelper = new JRubyJarHelper(osgiBundleFinder.getPlatformOSGIBundlesRootDir(), nodesApiHolder.getNodesApi());
        this.jrubyUniqueIndex = new AtomicInteger(0);
    }

    public List<BundleWithConfig> installBundles(Framework framework) {
        LinkedList<BundleWithConfig> installedBundles = new LinkedList<BundleWithConfig>();
        try {
            BundleContext context = framework.getBundleContext();
            String jrubyBundlePath = this.jRubyJarHelper.getAndValidateJrubyJarPath();
            this.installAllOSGIBundles(context, installedBundles, jrubyBundlePath);
            this.installAllJavaPluginBundles(context, installedBundles, jrubyBundlePath);
            this.installAllJRubyPluginBundles(context, installedBundles, jrubyBundlePath);
        }
        catch (PluginConfigException e) {
            logger.error("Error while parsing plugin configurations", (Throwable)e);
        }
        catch (BundleException e) {
            logger.error("Error while parsing plugin configurations", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while parsing plugin configurations", (Throwable)e);
        }
        return installedBundles;
    }

    public BundleWithConfig installNewBundle(String pluginName, @Nullable String version, Framework framework) {
        try {
            String osgiBundlePath = this.osgiBundleFinder.getOSGIPath(pluginName);
            if (osgiBundlePath != null) {
                Bundle bundle = this.installOSGIBundle(framework.getBundleContext(), osgiBundlePath);
                return new BundleWithConfig(bundle, null);
            }
            List<PluginConfig> configs = this.pluginFinder.getVersionsForPlugin(pluginName, version);
            if (configs.isEmpty() || version != null && configs.size() != 1) {
                throw new PluginConfigException("Cannot install plugin " + pluginName + ", version = " + version);
            }
            String jrubyBundlePath = this.jRubyJarHelper.getAndValidateJrubyJarPath();
            Bundle bundle = this.installBundle(configs.get(0), framework.getBundleContext(), configs.get(0).getPluginLanguage(), jrubyBundlePath);
            return new BundleWithConfig(bundle, configs.get(0));
        }
        catch (PluginConfigException e) {
            logger.error("Error while installing plugin " + pluginName, (Throwable)e);
        }
        catch (BundleException e) {
            logger.error("Error while installing plugin" + pluginName, (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while installing plugin " + pluginName, (Throwable)e);
        }
        return null;
    }

    private void installAllOSGIBundles(BundleContext context, List<BundleWithConfig> installedBundles, String jrubyBundlePath) throws PluginConfigException, BundleException {
        List<String> bundleJarPaths = this.osgiBundleFinder.getLatestBundles();
        for (String cur : bundleJarPaths) {
            if (jrubyBundlePath != null && jrubyBundlePath.equals(cur)) continue;
            Bundle bundle = this.installOSGIBundle(context, cur);
            installedBundles.add(new BundleWithConfig(bundle, null));
        }
    }

    private Bundle installOSGIBundle(BundleContext context, String path) throws BundleException {
        logger.info("Installing Java OSGI bundle from {}", (Object)path);
        Bundle bundle = context.installBundle("file:" + path);
        this.osgiBundleFinder.recordMappingPluginNameToPath(bundle.getSymbolicName(), path);
        return bundle;
    }

    private void installAllJavaPluginBundles(BundleContext context, List<BundleWithConfig> installedBundles, String jrubyBundlePath) throws PluginConfigException, BundleException, IOException {
        List<PluginJavaConfig> pluginJavaConfigs = this.pluginFinder.getLatestJavaPlugins();
        for (PluginJavaConfig cur : pluginJavaConfigs) {
            Bundle bundle = this.installBundle((PluginConfig)cur, context, PluginLanguage.JAVA, jrubyBundlePath);
            installedBundles.add(new BundleWithConfig(bundle, (PluginConfig)cur));
        }
    }

    private void installAllJRubyPluginBundles(BundleContext context, List<BundleWithConfig> installedBundles, String jrubyBundlePath) throws PluginConfigException, BundleException, IOException {
        if (jrubyBundlePath == null) {
            return;
        }
        List<PluginRubyConfig> pluginRubyConfigs = this.pluginFinder.getLatestRubyPlugins();
        for (PluginRubyConfig cur : pluginRubyConfigs) {
            Bundle bundle = this.installBundle((PluginConfig)cur, context, PluginLanguage.RUBY, jrubyBundlePath);
            installedBundles.add(new BundleWithConfig(bundle, (PluginConfig)cur));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Bundle installBundle(PluginConfig config, BundleContext context, PluginLanguage pluginLanguage, String jrubyBundlePath) throws BundleException {
        Bundle bundle;
        switch (pluginLanguage) {
            case JAVA: {
                PluginJavaConfig javaConfig = (PluginJavaConfig)config;
                String location = "file:" + javaConfig.getBundleJarPath();
                bundle = context.getBundle(location);
                if (bundle != null) break;
                logger.info("Installing Java bundle for plugin {} from {}", (Object)javaConfig.getPluginName(), (Object)javaConfig.getBundleJarPath());
                bundle = context.installBundle(location);
                ((DefaultPluginConfigServiceApi)this.pluginConfigServiceApi).registerBundle((Long)bundle.getBundleId(), javaConfig);
                break;
            }
            case RUBY: {
                PluginRubyConfig rubyConfig = (PluginRubyConfig)config;
                String uniqueJrubyBundlePath = "jruby-" + rubyConfig.getPluginName();
                bundle = context.getBundle(uniqueJrubyBundlePath);
                if (bundle != null) break;
                logger.info("Installing JRuby bundle for plugin {} ", (Object)uniqueJrubyBundlePath);
                InputStream tweakedInputStream = null;
                tweakedInputStream = this.tweakRubyManifestToBeUnique(jrubyBundlePath, this.jrubyUniqueIndex.incrementAndGet());
                bundle = context.installBundle(uniqueJrubyBundlePath, tweakedInputStream);
                ((DefaultPluginConfigServiceApi)this.pluginConfigServiceApi).registerBundle((Long)bundle.getBundleId(), rubyConfig);
                if (tweakedInputStream == null) break;
                try {
                    tweakedInputStream.close();
                }
                catch (IOException iOException) {}
                break;
                catch (IOException e) {
                    try {
                        logger.warn("Failed to open file {}", (Object)jrubyBundlePath);
                        if (tweakedInputStream == null) break;
                    }
                    catch (Throwable throwable) {
                        if (tweakedInputStream != null) {
                            try {
                                tweakedInputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        tweakedInputStream.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            default: {
                throw new IllegalStateException("Unknown pluginLanguage " + pluginLanguage);
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream tweakRubyManifestToBeUnique(String rubyJar, int index) throws IOException {
        Attributes.Name attrName = new Attributes.Name("Bundle-SymbolicName");
        JarInputStream in = new JarInputStream(new FileInputStream(new File(rubyJar)));
        Manifest manifest = in.getManifest();
        Object currentValue = manifest.getMainAttributes().get(attrName);
        manifest.getMainAttributes().put(attrName, currentValue.toString() + "-" + index);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);){
            JarEntry e = in.getNextJarEntry();
            while (e != null) {
                if (!e.getName().equals("META-INF/MANIFEST.MF")) {
                    jarOut.putNextEntry(e);
                    ByteStreams.copy((InputStream)in, (OutputStream)jarOut);
                }
                e = in.getNextJarEntry();
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public boolean startBundle(Bundle bundle) {
        if (bundle.getState() == 1) {
            logger.info("Skipping uninstalled bundle {}", (Object)bundle.getLocation());
        } else if (this.isFragment(bundle)) {
            logger.info("Skipping fragment bundle {}", (Object)bundle.getLocation());
        } else {
            logger.info("Starting bundle {}", (Object)bundle.getLocation());
            try {
                bundle.start();
                return true;
            }
            catch (BundleException e) {
                logger.warn("Unable to start bundle", (Throwable)e);
            }
        }
        return false;
    }

    private boolean isFragment(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return bundleRevision != null && (bundleRevision.getTypes() & 1) != 0;
    }
}

