/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.osgi.config.OSGIConfig;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PureOSGIBundleFinder {
    private final Logger logger = LoggerFactory.getLogger(Logger.class);
    private final OSGIConfig osgiConfig;
    private final Map<String, String> osgiPluginNameMapping;

    @Inject
    public PureOSGIBundleFinder(OSGIConfig osgiConfig) {
        this.osgiConfig = osgiConfig;
        this.osgiPluginNameMapping = new HashMap<String, String>();
    }

    public List<String> getLatestBundles() throws PluginConfigException {
        String rootDirPath = this.getPlatformOSGIBundlesRootDir();
        File rootDir = new File(rootDirPath);
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            this.logger.warn("Configuration root dir {} is not a valid directory", (Object)rootDirPath);
            return ImmutableList.of();
        }
        File[] files = rootDir.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        ArrayList<String> bundles = new ArrayList<String>();
        for (File bundleJar : files) {
            if (!bundleJar.isFile()) continue;
            bundles.add(bundleJar.getAbsolutePath());
        }
        return bundles;
    }

    public String getOSGIPath(String pluginName) {
        return this.osgiPluginNameMapping.get(pluginName);
    }

    public void recordMappingPluginNameToPath(String pluginName, String path) {
        this.osgiPluginNameMapping.put(pluginName, path);
    }

    public String getPlatformOSGIBundlesRootDir() {
        return this.osgiConfig.getRootInstallationDir() + "/platform/";
    }
}

