/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.glue;

import org.killbill.commons.jdbi.guice.DaoConfig;
import org.killbill.commons.jdbi.guice.DataSourceConnectionPoolingType;
import org.killbill.commons.jdbi.log.LogLevel;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.DefaultNull;
import org.skife.config.Description;
import org.skife.config.TimeSpan;

public interface OSGIDataSourceConfig
extends DaoConfig {
    public static final String DATA_SOURCE_PROP_PREFIX = "org.killbill.billing.osgi.dao.";

    @Description(value="The jdbc url for the database")
    @Config(value={"org.killbill.billing.osgi.dao.url"})
    @Default(value="jdbc:h2:file:/var/tmp/killbill;MODE=MYSQL;DB_CLOSE_DELAY=-1;MVCC=true;DB_CLOSE_ON_EXIT=FALSE")
    public String getJdbcUrl();

    @Description(value="The jdbc user name for the database")
    @Config(value={"org.killbill.billing.osgi.dao.user"})
    @Default(value="killbill")
    public String getUsername();

    @Description(value="The jdbc password for the database")
    @Config(value={"org.killbill.billing.osgi.dao.password"})
    @Default(value="killbill")
    public String getPassword();

    @Description(value="The minimum allowed number of idle connections to the database")
    @Config(value={"org.killbill.billing.osgi.dao.minIdle"})
    @Default(value="1")
    public int getMinIdle();

    @Description(value="The maximum allowed number of active connections to the database")
    @Config(value={"org.killbill.billing.osgi.dao.maxActive"})
    @Default(value="100")
    public int getMaxActive();

    @Description(value="Amount of time that a connection can be out of the pool before a message is logged indicating a possible connection leak")
    @Config(value={"org.killbill.billing.osgi.dao.leakDetectionThreshold"})
    @Default(value="60s")
    public TimeSpan getLeakDetectionThreshold();

    @Description(value="How long to wait before a connection attempt to the database is considered timed out")
    @Config(value={"org.killbill.billing.osgi.dao.connectionTimeout"})
    @Default(value="10s")
    public TimeSpan getConnectionTimeout();

    @Description(value="The time for a connection to remain unused before it is closed off")
    @Config(value={"org.killbill.billing.osgi.dao.idleMaxAge"})
    @Default(value="60m")
    public TimeSpan getIdleMaxAge();

    @Description(value="Any connections older than this setting will be closed off whether it is idle or not. Connections currently in use will not be affected until they are returned to the pool")
    @Config(value={"org.killbill.billing.osgi.dao.maxConnectionAge"})
    @Default(value="0m")
    public TimeSpan getMaxConnectionAge();

    @Description(value="Time for a connection to remain idle before sending a test query to the DB")
    @Config(value={"org.killbill.billing.osgi.dao.idleConnectionTestPeriod"})
    @Default(value="5m")
    public TimeSpan getIdleConnectionTestPeriod();

    @Description(value="Number of prepared statements that the driver will cache per connection")
    @Config(value={"org.killbill.billing.osgi.dao.prepStmtCacheSize"})
    @Default(value="500")
    public int getPreparedStatementsCacheSize();

    @Description(value="Maximum length of a prepared SQL statement that the driver will cache")
    @Config(value={"org.killbill.billing.osgi.dao.prepStmtCacheSqlLimit"})
    @Default(value="2048")
    public int getPreparedStatementsCacheSqlLimit();

    @Description(value="Enable prepared statements cache")
    @Config(value={"org.killbill.billing.osgi.dao.cachePrepStmts"})
    @Default(value="true")
    public boolean isPreparedStatementsCacheEnabled();

    @Description(value="Enable server-side prepared statements")
    @Config(value={"org.killbill.billing.osgi.dao.useServerPrepStmts"})
    @Default(value="true")
    public boolean isServerSidePreparedStatementsEnabled();

    @Description(value="DataSource class name provided by the JDBC driver, leave null for autodetection")
    @Config(value={"org.killbill.billing.osgi.dao.dataSourceClassName"})
    @DefaultNull
    public String getDataSourceClassName();

    @Description(value="JDBC driver to use (when dataSourceClassName is null)")
    @Config(value={"org.killbill.billing.osgi.dao.driverClassName"})
    @DefaultNull
    public String getDriverClassName();

    @Description(value="MySQL server version")
    @Config(value={"org.killbill.billing.osgi.dao.mysqlServerVersion"})
    @Default(value="5.1")
    public String getMySQLServerVersion();

    @Description(value="Log level for SQL queries")
    @Config(value={"org.killbill.billing.osgi.dao.logLevel"})
    @Default(value="DEBUG")
    public LogLevel getLogLevel();

    @Description(value="Connection pooling type")
    @Config(value={"org.killbill.billing.osgi.dao.poolingType"})
    @Default(value="HIKARICP")
    public DataSourceConnectionPoolingType getConnectionPoolingType();

    @Description(value="Whether or not initialization should fail on error immediately")
    @Config(value={"org.killbill.billing.osgi.dao.initializationFailFast"})
    @Default(value="false")
    public boolean isInitializationFailFast();

    @Description(value="Set the default transaction isolation level")
    @Config(value={"org.killbill.billing.osgi.dao.transactionIsolationLevel"})
    @Default(value="TRANSACTION_READ_COMMITTED")
    public String getTransactionIsolationLevel();

    @Description(value="Whether to put connections in read-only mode")
    @Config(value={"org.killbill.billing.osgi.dao.readOnly"})
    @Default(value="false")
    public boolean isReadOnly();
}

