/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.pluginconf;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginJavaConfig;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.api.config.PluginRubyConfig;
import org.killbill.billing.osgi.config.OSGIConfig;
import org.killbill.billing.osgi.pluginconf.DefaultPluginConfig;
import org.killbill.billing.osgi.pluginconf.DefaultPluginJavaConfig;
import org.killbill.billing.osgi.pluginconf.DefaultPluginRubyConfig;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;
import org.killbill.billing.osgi.pluginconf.PluginIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginFinder {
    static final String SELECTED_VERSION_LINK_NAME = "SET_DEFAULT";
    static final String TMP_DIR_NAME = "tmp";
    static final String DISABLED_FILE_NAME = "disabled.txt";
    static final String IDENTIFIERS_FILE_NAME = "plugin_identifiers.json";
    private final Logger logger = LoggerFactory.getLogger(PluginFinder.class);
    private final OSGIConfig osgiConfig;
    private final Map<String, LinkedList<PluginConfig>> allPlugins;
    private final Map<String, PluginIdentifier> identifiers;
    private final ObjectMapper mapper;

    @Inject
    public PluginFinder(OSGIConfig osgiConfig) {
        this.osgiConfig = osgiConfig;
        this.mapper = new ObjectMapper();
        this.allPlugins = new HashMap<String, LinkedList<PluginConfig>>();
        this.identifiers = new HashMap<String, PluginIdentifier>();
    }

    public List<PluginJavaConfig> getLatestJavaPlugins() throws PluginConfigException, IOException {
        return this.getLatestPluginForLanguage(PluginLanguage.JAVA);
    }

    public List<PluginRubyConfig> getLatestRubyPlugins() throws PluginConfigException, IOException {
        return this.getLatestPluginForLanguage(PluginLanguage.RUBY);
    }

    public List<PluginConfig> getVersionsForPlugin(String lookupName, @Nullable String version) throws PluginConfigException, IOException {
        this.loadPluginsIfRequired(false);
        LinkedList<PluginConfig> result = new LinkedList<PluginConfig>();
        for (String pluginName : this.allPlugins.keySet()) {
            if (!pluginName.equals(lookupName)) continue;
            for (PluginConfig cur : this.allPlugins.get(pluginName)) {
                if (version != null && !cur.getVersion().equals(version)) continue;
                result.add(cur);
            }
        }
        return result;
    }

    public String getPluginVersionSelectedForStart(String pluginName) {
        LinkedList<PluginConfig> pluginConfigs = this.allPlugins.get(pluginName);
        return pluginConfigs != null && !pluginConfigs.isEmpty() ? pluginConfigs.get(0).getVersion() : null;
    }

    public Map<String, LinkedList<PluginConfig>> getAllPlugins() {
        return this.allPlugins;
    }

    public void reloadPlugins() throws PluginConfigException, IOException {
        this.loadPluginsIfRequired(true);
    }

    public PluginIdentifier resolvePluginKey(String pluginKey) {
        return this.identifiers.get(pluginKey);
    }

    private <T extends PluginConfig> List<T> getLatestPluginForLanguage(PluginLanguage pluginLanguage) throws PluginConfigException, IOException {
        this.loadPluginsIfRequired(false);
        LinkedList<PluginConfig> result = new LinkedList<PluginConfig>();
        for (String pluginName : this.allPlugins.keySet()) {
            PluginConfig plugin = this.allPlugins.get(pluginName).get(0);
            if (pluginLanguage != plugin.getPluginLanguage()) continue;
            result.add(plugin);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PluginConfig> void loadPluginsIfRequired(boolean reloadPlugins) throws PluginConfigException, IOException {
        Map<String, LinkedList<PluginConfig>> map = this.allPlugins;
        synchronized (map) {
            if (!reloadPlugins && !this.allPlugins.isEmpty()) {
                return;
            }
            this.allPlugins.clear();
            this.readPluginIdentifiers();
            this.loadPluginsForLanguage(PluginLanguage.RUBY);
            this.loadPluginsForLanguage(PluginLanguage.JAVA);
            Iterator<String> pluginNamesIterator = this.allPlugins.keySet().iterator();
            while (pluginNamesIterator.hasNext()) {
                String pluginName = pluginNamesIterator.next();
                LinkedList<PluginConfig> versionsForPlugin = this.allPlugins.get(pluginName);
                if (versionsForPlugin.isEmpty()) {
                    pluginNamesIterator.remove();
                    continue;
                }
                Collections.sort(versionsForPlugin);
                PluginConfig firstValue = versionsForPlugin.removeFirst();
                DefaultPluginConfig newFirstValue = firstValue.getPluginLanguage() == PluginLanguage.RUBY ? new DefaultPluginRubyConfig((DefaultPluginRubyConfig)firstValue, true) : new DefaultPluginJavaConfig((DefaultPluginJavaConfig)firstValue, true);
                versionsForPlugin.addFirst(newFirstValue);
            }
        }
    }

    private void readPluginIdentifiers() {
        String identifierFileName = this.osgiConfig.getRootInstallationDir() + "/plugins/" + IDENTIFIERS_FILE_NAME;
        File identifierFile = new File(identifierFileName);
        if (!identifierFile.exists() || !identifierFile.isFile()) {
            this.logger.warn("File non existent: Skipping parsing of plugin_identifiers.json");
            return;
        }
        try {
            this.identifiers.clear();
            Map map = (Map)this.mapper.readValue(identifierFile, (TypeReference)new TypeReference<Map<String, PluginIdentifier>>(){});
            this.identifiers.putAll(map);
        }
        catch (IOException e) {
            this.logger.warn("Exception when parsing plugin_identifiers.json:", (Throwable)e);
            return;
        }
    }

    private String resolveVersionToStartLink(File pluginVersionsRoot) throws IOException {
        File selectedVersionLink = new File(pluginVersionsRoot + "/" + SELECTED_VERSION_LINK_NAME);
        if (selectedVersionLink.exists() && selectedVersionLink.isDirectory()) {
            return selectedVersionLink.getCanonicalFile().getName();
        }
        return null;
    }

    private void loadPluginsForLanguage(PluginLanguage pluginLanguage) throws PluginConfigException, IOException {
        String rootDirPath = this.osgiConfig.getRootInstallationDir() + "/plugins/" + pluginLanguage.toString().toLowerCase();
        File rootDir = new File(rootDirPath);
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            this.logger.warn("Configuration root dir {} is not a valid directory", (Object)rootDirPath);
            return;
        }
        File[] files = rootDir.listFiles();
        if (files == null) {
            return;
        }
        for (File curPlugin : files) {
            if (!curPlugin.isDirectory()) {
                this.logger.warn("Skipping entry {} in directory {}", (Object)curPlugin.getName(), (Object)rootDir.getAbsolutePath());
                continue;
            }
            String pluginName = curPlugin.getName();
            File[] filesInDir = curPlugin.listFiles();
            if (filesInDir == null) continue;
            String versionToStart = this.resolveVersionToStartLink(curPlugin);
            LinkedList<Object> curPluginVersionlist = this.allPlugins.get(pluginName);
            if (curPluginVersionlist == null) {
                curPluginVersionlist = new LinkedList();
                this.allPlugins.put(pluginName, curPluginVersionlist);
            }
            for (File curVersion : filesInDir) {
                PluginConfig plugin;
                if (!curVersion.isDirectory()) {
                    this.logger.warn("Skipping entry {} in directory {}", (Object)curPlugin.getName(), (Object)rootDir.getAbsolutePath());
                    continue;
                }
                String version = curVersion.getName();
                if (SELECTED_VERSION_LINK_NAME.equals(version)) continue;
                boolean isVersionToStartLink = versionToStart != null && versionToStart.equals(version);
                try {
                    plugin = this.extractPluginConfig(pluginLanguage, pluginName, version, curVersion, isVersionToStartLink);
                }
                catch (PluginConfigException e) {
                    this.logger.warn("Skipping plugin {}: {}", (Object)pluginName, (Object)e.getMessage());
                    continue;
                }
                if (plugin.isDisabled()) continue;
                curPluginVersionlist.add(plugin);
                this.logger.info("Adding plugin {} ", (Object)plugin.getPluginVersionnedName());
            }
        }
    }

    private String findPluginKey(String pluginName, PluginLanguage pluginLanguage) {
        for (String key : this.identifiers.keySet()) {
            PluginIdentifier value = this.identifiers.get(key);
            if (!value.getPluginName().equals(pluginName) || !value.getLanguage().equalsIgnoreCase(pluginLanguage.name())) continue;
            return key;
        }
        return null;
    }

    private PluginConfig extractPluginConfig(PluginLanguage pluginLanguage, String pluginName, String pluginVersion, File pluginVersionDir, boolean isVersionToStartLink) throws PluginConfigException {
        DefaultPluginConfig result;
        Properties props = null;
        try {
            File[] files = pluginVersionDir.listFiles();
            if (files == null) {
                throw new PluginConfigException("Unable to list files in " + pluginVersionDir.getAbsolutePath());
            }
            for (File cur : files) {
                if (cur.isFile() && cur.getName().equals(this.osgiConfig.getOSGIKillbillPropertyName())) {
                    props = this.readPluginConfigurationFile(cur);
                }
                if (props != null) break;
            }
            if (pluginLanguage == PluginLanguage.RUBY && props == null) {
                throw new PluginConfigException("Invalid plugin configuration file for " + pluginName + "-" + pluginVersion);
            }
        }
        catch (IOException e) {
            throw new PluginConfigException("Failed to read property file for " + pluginName + "-" + pluginVersion, e);
        }
        String pluginKey = this.findPluginKey(pluginName, pluginLanguage);
        switch (pluginLanguage) {
            case RUBY: {
                result = new DefaultPluginRubyConfig(pluginKey, pluginName, pluginVersion, pluginVersionDir, props, isVersionToStartLink, this.isPluginDisabled(pluginVersionDir));
                break;
            }
            case JAVA: {
                result = new DefaultPluginJavaConfig(pluginKey, pluginName, pluginVersion, pluginVersionDir, props == null ? new Properties() : props, isVersionToStartLink, this.isPluginDisabled(pluginVersionDir));
                break;
            }
            default: {
                throw new RuntimeException("Unknown plugin language " + pluginLanguage);
            }
        }
        return result;
    }

    private boolean isPluginDisabled(File pluginVersionDir) {
        File disabledFile = new File(pluginVersionDir + "/" + TMP_DIR_NAME + "/" + DISABLED_FILE_NAME);
        return disabledFile.isFile();
    }

    private Properties readPluginConfigurationFile(File config) throws IOException {
        String line;
        Properties props = new Properties();
        BufferedReader br = new BufferedReader(new FileReader(config));
        while ((line = br.readLine()) != null) {
            String[] parts = line.split("\\s*=\\s*");
            String key = parts[0];
            String value = parts[1];
            props.put(key, value);
        }
        br.close();
        return props;
    }
}

