/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.http;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.killbill.billing.osgi.http.DefaultServletRouter;

@Singleton
public class OSGIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    final Vector<Servlet> initializedServlets = new Vector();
    private final Object servletsMonitor = new Object();
    @Inject
    @VisibleForTesting
    transient DefaultServletRouter servletRouter;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceViaPlugin(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceViaPlugin(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceViaPlugin(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceViaPlugin(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceViaPlugin(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceViaPlugin(req, resp);
    }

    private void serviceViaPlugin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestPath = req.getServletPath() + req.getPathInfo();
        Servlet pluginServlet = this.getPluginServlet(requestPath);
        if (pluginServlet != null) {
            this.initializeServletIfNeeded(req, pluginServlet);
            OSGIServletRequestWrapper requestWrapper = new OSGIServletRequestWrapper(req, this.servletRouter.getPluginPrefixForPath(requestPath));
            pluginServlet.service((ServletRequest)requestWrapper, (ServletResponse)resp);
        } else {
            resp.sendError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeServletIfNeeded(HttpServletRequest req, Servlet pluginServlet) throws ServletException {
        if (!this.initializedServlets.contains(pluginServlet)) {
            Object object = this.servletsMonitor;
            synchronized (object) {
                ServletConfig servletConfig;
                if (!this.initializedServlets.contains(pluginServlet) && (servletConfig = (ServletConfig)req.getAttribute("killbill.osgi.servletConfig")) != null) {
                    pluginServlet.init(servletConfig);
                    this.initializedServlets.add(pluginServlet);
                }
            }
        }
    }

    private Servlet getPluginServlet(String requestPath) {
        if (requestPath != null) {
            return this.servletRouter.getServiceForPath(requestPath);
        }
        return null;
    }

    private static final class OSGIServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final String pluginPrefix;

        public OSGIServletRequestWrapper(HttpServletRequest request, String pluginPrefix) {
            super(request);
            this.pluginPrefix = pluginPrefix;
        }

        public String getPathInfo() {
            return super.getPathInfo().replace(this.pluginPrefix, "");
        }

        public String getContextPath() {
            return super.getContextPath() + this.pluginPrefix;
        }
    }
}

