/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.osgi.KillbillEventObservable;
import org.killbill.billing.osgi.api.KillbillEventRetriableBusHandlerService;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.queue.QueueObjectMapper;
import org.killbill.queue.retry.RetryableService;
import org.killbill.queue.retry.RetryableSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class KillbillEventRetriableBusHandler
extends RetryableService
implements KillbillEventRetriableBusHandlerService {
    private final Logger logger = LoggerFactory.getLogger(KillbillEventRetriableBusHandler.class);
    private final PersistentBus externalBus;
    private final KillbillEventObservable killbillEventObservable;
    private final RetryableSubscriber retryableSubscriber;
    private final RetryableSubscriber.SubscriberQueueHandler subscriberQueueHandler = new RetryableSubscriber.SubscriberQueueHandler();

    @Inject
    public KillbillEventRetriableBusHandler(@Named(value="externalBus") PersistentBus externalBus, final KillbillEventObservable killbillEventObservable, NotificationQueueService notificationQueueService, Clock clock) {
        super(notificationQueueService);
        this.externalBus = externalBus;
        this.killbillEventObservable = killbillEventObservable;
        this.subscriberQueueHandler.subscribe(OSGIBusEvent.class, (RetryableSubscriber.SubscriberAction)new RetryableSubscriber.SubscriberAction<OSGIBusEvent>(){

            public void run(OSGIBusEvent osgiBusEvent) {
                ExtBusEvent extBusEvent = osgiBusEvent.getExtBusEvent();
                KillbillEventRetriableBusHandler.this.logger.debug("Received external event " + extBusEvent.toString());
                killbillEventObservable.setChangedAndNotifyObservers(extBusEvent);
            }
        });
        this.retryableSubscriber = new RetryableSubscriber(clock, (RetryableService)this, (NotificationQueueService.NotificationQueueHandler)this.subscriberQueueHandler);
    }

    public void register() throws PersistentBus.EventBusException {
        this.externalBus.register((Object)this);
    }

    public void unregister() throws PersistentBus.EventBusException {
        this.killbillEventObservable.deleteObservers();
        if (this.externalBus != null) {
            this.externalBus.unregister((Object)this);
        }
    }

    public String getName() {
        return KillbillService.KILLBILL_SERVICES.RETRIABLE_BUS_HANDLER_SERVICE.getServiceName();
    }

    public int getRegistrationOrdering() {
        return KillbillService.KILLBILL_SERVICES.RETRIABLE_BUS_HANDLER_SERVICE.getRegistrationOrdering();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
    public void initialize() {
        super.initialize("extBusEvent-listener", (NotificationQueueService.NotificationQueueHandler)this.subscriberQueueHandler);
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.START_SERVICE)
    public void start() {
        super.start();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_SERVICE)
    public void stop() throws NotificationQueueService.NoSuchNotificationQueue {
        super.stop();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handleKillbillEvent(ExtBusEvent extBusEvent) {
        OSGIBusEvent event = new OSGIBusEvent(extBusEvent, extBusEvent.getClass());
        this.retryableSubscriber.handleEvent((BusEvent)event);
    }

    protected static class OSGIBusEventDeserializer
    extends JsonDeserializer<OSGIBusEvent> {
        private static final ObjectMapper objectMapper = QueueObjectMapper.get();

        protected OSGIBusEventDeserializer() {
        }

        public OSGIBusEvent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Class<?> extBusEventClass;
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            try {
                extBusEventClass = Class.forName(node.get("extBusEventClass").textValue());
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            return new OSGIBusEvent((ExtBusEvent)objectMapper.treeToValue((TreeNode)node.get("extBusEvent"), extBusEventClass), extBusEventClass);
        }
    }

    @JsonDeserialize(using=OSGIBusEventDeserializer.class)
    protected static class OSGIBusEvent
    implements BusEvent {
        private final ExtBusEvent extBusEvent;
        private final Class extBusEventClass;

        @JsonCreator
        public OSGIBusEvent(@JsonProperty(value="extBusEvent") ExtBusEvent extBusEvent, @JsonProperty(value="extBusEventClass") Class extBusEventClass) {
            this.extBusEvent = extBusEvent;
            this.extBusEventClass = extBusEventClass;
        }

        public ExtBusEvent getExtBusEvent() {
            return this.extBusEvent;
        }

        public Class getExtBusEventClass() {
            return this.extBusEventClass;
        }

        public Long getSearchKey1() {
            UUID accountId = this.extBusEvent.getAccountId();
            return accountId == null ? null : Long.valueOf(accountId.getMostSignificantBits() & Long.MAX_VALUE);
        }

        public Long getSearchKey2() {
            UUID tenantId = this.extBusEvent.getTenantId();
            return tenantId == null ? null : Long.valueOf(tenantId.getMostSignificantBits() & Long.MAX_VALUE);
        }

        public UUID getUserToken() {
            return this.extBusEvent.getUserToken();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OSGIBusEvent{");
            sb.append("extBusEvent=").append(this.extBusEvent);
            sb.append(", extBusEventClass=").append(this.extBusEventClass);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OSGIBusEvent event = (OSGIBusEvent)o;
            if (this.extBusEvent != null ? !this.extBusEvent.equals(event.extBusEvent) : event.extBusEvent != null) {
                return false;
            }
            return this.extBusEventClass != null ? this.extBusEventClass.equals(event.extBusEventClass) : event.extBusEventClass == null;
        }

        public int hashCode() {
            int result = this.extBusEvent != null ? this.extBusEvent.hashCode() : 0;
            result = 31 * result + (this.extBusEventClass != null ? this.extBusEventClass.hashCode() : 0);
            return result;
        }
    }
}

