/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.pluginconf;

import java.io.File;
import java.util.Properties;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.api.config.PluginRubyConfig;
import org.killbill.billing.osgi.pluginconf.DefaultPluginConfig;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;

public class DefaultPluginRubyConfig
extends DefaultPluginConfig
implements PluginRubyConfig {
    private static final String PROP_RUBY_MAIN_CLASS_NAME = "mainClass";
    private static final String PROP_RUBY_REQUIRE = "require";
    private final String rubyMainClass;
    private final String rubyLoadDir;
    private final String rubyRequire;

    public DefaultPluginRubyConfig(DefaultPluginRubyConfig input, boolean isSelectedForStart) throws PluginConfigException {
        super(input, isSelectedForStart);
        this.rubyMainClass = input.getRubyMainClass();
        this.rubyLoadDir = input.getRubyLoadDir();
        this.rubyRequire = input.getRubyRequire();
    }

    public DefaultPluginRubyConfig(String pluginKey, String pluginName, String version, File pluginVersionRoot, Properties props, boolean isVersionToStartLinkedToMe, boolean isDisabled) throws PluginConfigException {
        super(pluginKey, pluginName, version, props, pluginVersionRoot, isVersionToStartLinkedToMe, isDisabled);
        this.rubyMainClass = props.getProperty(PROP_RUBY_MAIN_CLASS_NAME);
        File rubyGemsDir = new File(pluginVersionRoot.getAbsoluteFile(), "gems");
        this.rubyLoadDir = rubyGemsDir.isDirectory() ? rubyGemsDir.getAbsolutePath() : null;
        this.rubyRequire = props.getProperty(PROP_RUBY_REQUIRE);
        this.validate();
    }

    @Override
    protected void validate() throws PluginConfigException {
        if (this.rubyMainClass == null) {
            throw new PluginConfigException("Missing property mainClass for plugin " + this.getPluginVersionnedName());
        }
        if (this.rubyLoadDir != null && !new File(this.rubyLoadDir).exists()) {
            throw new PluginConfigException("Missing gem installation directory " + this.rubyLoadDir + " for plugin " + this.getPluginVersionnedName());
        }
    }

    public String getRubyMainClass() {
        return this.rubyMainClass;
    }

    @Deprecated
    public String getRubyLoadDir() {
        return this.rubyLoadDir;
    }

    public String getRubyRequire() {
        return this.rubyRequire;
    }

    @Override
    public PluginLanguage getPluginLanguage() {
        return PluginLanguage.RUBY;
    }
}

