/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nullable;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRubyJarHelper {
    private static final Logger logger = LoggerFactory.getLogger(JRubyJarHelper.class);
    static final String POM_PROPERTIES = "META-INF/maven/org.kill-bill.billing/killbill-platform-osgi-bundles-jruby/pom.properties";
    private final KillbillNodesApi nodesApi;
    private final String jrubyJarPath;

    public JRubyJarHelper(String platformOSGIBundlesRootDir, @Nullable KillbillNodesApi nodesApi) {
        this.jrubyJarPath = platformOSGIBundlesRootDir + "jruby.jar";
        this.nodesApi = nodesApi;
    }

    public String getAndValidateJrubyJarPath() {
        if (new File(this.jrubyJarPath).isFile()) {
            this.logIfVersionMismatch();
            return this.jrubyJarPath;
        }
        logger.warn("Unable to find the JRuby bundle at {}, ruby plugins won't be started!", (Object)this.jrubyJarPath);
        return null;
    }

    private void logIfVersionMismatch() {
        try {
            NodeInfo nodeInfo;
            NodeInfo nodeInfo2 = nodeInfo = this.nodesApi == null ? null : this.nodesApi.getCurrentNodeInfo();
            if (nodeInfo == null) {
                logger.warn("Failed to get current NodeInfo to validate jruby.jar {}", (Object)this.jrubyJarPath);
                return;
            }
            String platformVersion = nodeInfo.getPlatformVersion();
            Properties properties = this.getProperties(this.jrubyJarPath, POM_PROPERTIES);
            String jrubyJarVersion = this.extractVersion(properties);
            if (jrubyJarVersion == null) {
                logger.warn("Failed to extract jruby.jar version from file {}", (Object)this.jrubyJarPath);
                return;
            }
            if (!jrubyJarVersion.equals(platformVersion)) {
                logger.warn("Detected version mismatch between existing jruby.jar [version={}] and platform [version={}]", (Object)jrubyJarVersion, (Object)platformVersion);
                return;
            }
        }
        catch (IOException e) {
            logger.warn("Failed to validate jruby.jar version:", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private Properties getProperties(String jarFileName, String entryName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    String extractVersion(Properties properties) {
        return (String)properties.get("version");
    }
}

