/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.inject.Inject;
import org.killbill.billing.notification.plugin.api.BroadcastMetadata;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.notification.plugin.api.ExtBusEventType;
import org.killbill.billing.osgi.BundleRegistry;
import org.killbill.billing.osgi.KillbillActivator;
import org.killbill.billing.osgi.api.DefaultPluginsInfoApi;
import org.killbill.billing.osgi.api.KillbillNodesApiHolder;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginServiceInfo;
import org.killbill.billing.osgi.api.PluginsInfoApi;
import org.killbill.billing.osgi.pluginconf.PluginFinder;
import org.killbill.billing.util.nodes.DefaultNodeCommandMetadata;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeCommandMetadata;
import org.killbill.billing.util.nodes.PluginNodeCommandMetadata;
import org.killbill.billing.util.nodes.SystemNodeCommandType;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIListener {
    private static final Logger logger = LoggerFactory.getLogger(OSGIListener.class);
    private final ObjectMapper objectMapper;
    private final BundleRegistry bundleRegistry;
    private final PluginFinder pluginFinder;
    private final PluginsInfoApi pluginsInfoApi;
    private final KillbillNodesApi nodesApi;
    private final KillbillActivator killbillActivator;

    @Inject
    public OSGIListener(KillbillActivator killbillActivator, BundleRegistry bundleRegistry, PluginFinder pluginFinder, PluginsInfoApi pluginsInfoApi, KillbillNodesApiHolder nodesApiHolder) {
        this.killbillActivator = killbillActivator;
        this.bundleRegistry = bundleRegistry;
        this.pluginFinder = pluginFinder;
        this.pluginsInfoApi = pluginsInfoApi;
        this.nodesApi = nodesApiHolder.getNodesApi();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JodaModule());
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handleKillbillEvent(ExtBusEvent event) throws IOException, BundleException {
        String pluginName;
        if (event.getEventType() != ExtBusEventType.BROADCAST_SERVICE) {
            return;
        }
        BroadcastMetadata metadata = (BroadcastMetadata)this.objectMapper.readValue(event.getMetaData(), BroadcastMetadata.class);
        SystemNodeCommandType commandType = this.getSystemNodeCommandTypeOrNull(metadata.getCommandType());
        if (commandType == null || commandType != SystemNodeCommandType.START_PLUGIN && commandType != SystemNodeCommandType.STOP_PLUGIN && commandType != SystemNodeCommandType.RESTART_PLUGIN) {
            return;
        }
        PluginNodeCommandMetadata nodeCommandMetadata = (PluginNodeCommandMetadata)this.deserializeNodeCommand(metadata.getEventJson(), metadata.getCommandType());
        String string = nodeCommandMetadata.getPluginName() != null ? nodeCommandMetadata.getPluginName() : (pluginName = this.pluginFinder.resolvePluginKey(nodeCommandMetadata.getPluginKey()) != null ? this.pluginFinder.resolvePluginKey(nodeCommandMetadata.getPluginKey()).getPluginName() : null);
        if (pluginName == null) {
            logger.warn(String.format("Failed to dispatch event %s : Input must have a pluginName or a valid pluginKey specified json=%s", commandType, metadata.getEventJson()));
            return;
        }
        BundleRegistry.BundleWithMetadata bundleWithMetadata = null;
        switch (commandType) {
            case STOP_PLUGIN: {
                this.bundleRegistry.stopAndUninstallNewBundle(pluginName, nodeCommandMetadata.getPluginVersion());
                break;
            }
            case START_PLUGIN: {
                bundleWithMetadata = this.bundleRegistry.installAndStartNewBundle(pluginName, nodeCommandMetadata.getPluginVersion());
                break;
            }
            case RESTART_PLUGIN: {
                this.bundleRegistry.stopAndUninstallNewBundle(pluginName, nodeCommandMetadata.getPluginVersion());
                bundleWithMetadata = this.bundleRegistry.installAndStartNewBundle(pluginName, nodeCommandMetadata.getPluginVersion());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type " + commandType);
            }
        }
        String defaultPluginVersion = this.pluginFinder.getPluginVersionSelectedForStart(nodeCommandMetadata.getPluginName());
        boolean isSelectedForStart = defaultPluginVersion != null && nodeCommandMetadata.getPluginVersion() != null ? defaultPluginVersion.equals(nodeCommandMetadata.getPluginVersion()) : true;
        String symbolicName = bundleWithMetadata != null && bundleWithMetadata.getBundle() != null ? bundleWithMetadata.getBundle().getSymbolicName() : null;
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        eventProperties.put("pluginName", pluginName);
        eventProperties.put("pluginKey", nodeCommandMetadata.getPluginKey());
        eventProperties.put("symbolicName", symbolicName);
        this.killbillActivator.sendEvent("org/killbill/billing/osgi/plugin/" + commandType, eventProperties);
        DefaultPluginsInfoApi.DefaultPluginInfo pluginInfo = new DefaultPluginsInfoApi.DefaultPluginInfo(nodeCommandMetadata.getPluginKey(), symbolicName, nodeCommandMetadata.getPluginName(), nodeCommandMetadata.getPluginVersion(), DefaultPluginsInfoApi.toPluginState(bundleWithMetadata), isSelectedForStart, (Set<PluginServiceInfo>)ImmutableSet.of());
        this.nodesApi.notifyPluginChanged((PluginInfo)pluginInfo, this.pluginsInfoApi.getPluginsInfo());
    }

    private SystemNodeCommandType getSystemNodeCommandTypeOrNull(final String command) {
        return (SystemNodeCommandType)Iterables.tryFind((Iterable)ImmutableList.copyOf((Object[])SystemNodeCommandType.values()), (Predicate)new Predicate<SystemNodeCommandType>(){

            public boolean apply(SystemNodeCommandType input) {
                return input != null && input.name().equals(command);
            }
        }).orNull();
    }

    private NodeCommandMetadata deserializeNodeCommand(String nodeCommand, final String type) throws IOException {
        SystemNodeCommandType systemType = (SystemNodeCommandType)Iterables.tryFind((Iterable)ImmutableList.copyOf((Object[])SystemNodeCommandType.values()), (Predicate)new Predicate<SystemNodeCommandType>(){

            public boolean apply(SystemNodeCommandType input) {
                return input != null && input.name().equals(type);
            }
        }).orNull();
        return systemType != null ? (NodeCommandMetadata)this.objectMapper.readValue(nodeCommand, systemType.getCommandMetadataClass()) : (NodeCommandMetadata)this.objectMapper.readValue(nodeCommand, DefaultNodeCommandMetadata.class);
    }
}

