/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultServletRouter
implements OSGIServiceRegistration<Servlet> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServletRouter.class);
    private final Map<String, Servlet> pluginPathServlets = new HashMap<String, Servlet>();
    private final Map<String, OSGIServiceDescriptor> pluginRegistrations = new HashMap<String, OSGIServiceDescriptor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(OSGIServiceDescriptor desc, Servlet httpServlet) {
        String pathPrefix = this.getPathPrefixFromDescriptor(desc);
        if (pathPrefix == null) {
            logger.warn("Skipping registration of OSGI servlet for service {} (service info is not specified)", (Object)desc.getRegistrationName());
            return;
        }
        logger.info("Registering OSGI servlet at " + pathPrefix);
        DefaultServletRouter defaultServletRouter = this;
        synchronized (defaultServletRouter) {
            this.registerServletInternal(pathPrefix, httpServlet);
            this.registerServiceInternal(desc);
        }
    }

    public void registerServiceFromPath(String path, Servlet httpServlet) {
        String pathPrefix = DefaultServletRouter.sanitizePathPrefix(path);
        this.registerServletInternal(pathPrefix, httpServlet);
    }

    private void registerServletInternal(String pathPrefix, Servlet httpServlet) {
        this.pluginPathServlets.put(pathPrefix, httpServlet);
    }

    private void registerServiceInternal(OSGIServiceDescriptor desc) {
        this.pluginRegistrations.put(desc.getRegistrationName(), desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(String serviceName) {
        DefaultServletRouter defaultServletRouter = this;
        synchronized (defaultServletRouter) {
            OSGIServiceDescriptor desc = this.pluginRegistrations.get(serviceName);
            if (desc != null) {
                String pathPrefix = this.getPathPrefixFromDescriptor(desc);
                if (pathPrefix == null) {
                    logger.warn("Skipping unregistration of OSGI servlet for service {} (service info is not specified)", (Object)desc.getRegistrationName());
                    return;
                }
                logger.info("Unregistering OSGI servlet " + desc.getRegistrationName() + " at path " + pathPrefix);
                DefaultServletRouter defaultServletRouter2 = this;
                synchronized (defaultServletRouter2) {
                    this.unRegisterServletInternal(pathPrefix);
                    this.unRegisterServiceInternal(desc);
                }
            }
        }
    }

    public void unregisterServiceFromPath(String path) {
        String pathPrefix = DefaultServletRouter.sanitizePathPrefix(path);
        this.unRegisterServletInternal(pathPrefix);
    }

    private Servlet unRegisterServletInternal(String pathPrefix) {
        return this.pluginPathServlets.remove(pathPrefix);
    }

    private OSGIServiceDescriptor unRegisterServiceInternal(OSGIServiceDescriptor desc) {
        return this.pluginRegistrations.remove(desc.getRegistrationName());
    }

    public Servlet getServiceForName(String serviceName) {
        OSGIServiceDescriptor desc = this.pluginRegistrations.get(serviceName);
        if (desc == null) {
            return null;
        }
        String registeredPath = this.getPathPrefixFromDescriptor(desc);
        return this.pluginPathServlets.get(registeredPath);
    }

    private String getPathPrefixFromDescriptor(OSGIServiceDescriptor desc) {
        return DefaultServletRouter.sanitizePathPrefix(desc.getRegistrationName());
    }

    public Servlet getServiceForPath(String path) {
        return this.getServletForPathPrefix(path);
    }

    public Set<String> getAllServices() {
        return this.pluginRegistrations.keySet();
    }

    public Class<Servlet> getServiceType() {
        return Servlet.class;
    }

    public String getPluginPrefixForPath(String pathPrefix) {
        String bestMatch = null;
        for (String potentialMatch : this.pluginPathServlets.keySet()) {
            if (!pathPrefix.startsWith(potentialMatch) || bestMatch != null && bestMatch.length() >= potentialMatch.length()) continue;
            bestMatch = potentialMatch;
        }
        return bestMatch;
    }

    private Servlet getServletForPathPrefix(String pathPrefix) {
        String bestMatch = this.getPluginPrefixForPath(pathPrefix);
        return bestMatch == null ? null : this.pluginPathServlets.get(bestMatch);
    }

    private static String sanitizePathPrefix(String inputPath) {
        if (inputPath == null) {
            return null;
        }
        String pathPrefix = inputPath.charAt(0) != '/' ? "/" + inputPath : inputPath;
        return pathPrefix;
    }
}

