/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.osgi.BundleWithConfig;
import org.killbill.billing.osgi.FileInstall;
import org.killbill.billing.osgi.api.DefaultPluginsInfoApi;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.PluginServiceInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleRegistry {
    private static final Logger log = LoggerFactory.getLogger(BundleRegistry.class);
    private final FileInstall fileInstall;
    private final Map<String, BundleWithMetadata> registry;
    private Framework framework;
    private List<BundleWithConfig> bundleWithConfigs;

    @Inject
    public BundleRegistry(FileInstall fileInstall) {
        this.fileInstall = fileInstall;
        this.registry = new HashMap<String, BundleWithMetadata>();
    }

    public void installBundles(Framework framework) {
        this.framework = framework;
        this.bundleWithConfigs = this.fileInstall.installBundles(framework);
        for (BundleWithConfig bundleWithConfig : this.bundleWithConfigs) {
            this.registry.put(BundleRegistry.getPluginName(bundleWithConfig), new BundleWithMetadata(bundleWithConfig));
        }
    }

    public BundleWithMetadata installAndStartNewBundle(String pluginName, @Nullable String pluginVersion) throws BundleException {
        BundleWithMetadata bundle = this.registry.get(pluginName);
        if (bundle != null) {
            throw new IllegalStateException(String.format("Plugin %s version %s cannot be started because the version %s already exists in the registry (state = %s)", bundle.getPluginName(), pluginVersion, bundle.getVersion(), bundle.getBundle().getState()));
        }
        BundleWithConfig bundleWithConfig = this.fileInstall.installNewBundle(pluginName, pluginVersion, this.framework);
        BundleWithMetadata bundleWithMetadata = new BundleWithMetadata(bundleWithConfig);
        if (this.fileInstall.startBundle(bundleWithConfig.getBundle())) {
            this.registry.put(BundleRegistry.getPluginName(bundleWithConfig), bundleWithMetadata);
        }
        return bundleWithMetadata;
    }

    public BundleWithMetadata stopAndUninstallNewBundle(String pluginName, @Nullable String pluginVersion) throws BundleException {
        BundleWithMetadata bundle = this.registry.get(pluginName);
        if (bundle != null && (pluginVersion == null || bundle.getVersion().equals(pluginVersion))) {
            this.stopAndUninstallBundle(bundle.getBundle(), pluginName);
        }
        return bundle;
    }

    private void stopAndUninstallBundle(Bundle bundle, String pluginName) throws BundleException {
        if (bundle.getState() == 32) {
            bundle.stop();
        }
        bundle.uninstall();
        this.registry.remove(pluginName);
    }

    public void startBundles() {
        for (BundleWithConfig bundleWithConfig : this.bundleWithConfigs) {
            boolean isBundleStarted = this.fileInstall.startBundle(bundleWithConfig.getBundle());
            if (isBundleStarted) continue;
            this.registry.remove(BundleRegistry.getPluginName(bundleWithConfig));
        }
    }

    public void stopBundles() {
        for (BundleWithConfig bundleWithConfig : this.bundleWithConfigs) {
            try {
                if (bundleWithConfig.getBundle() == null || bundleWithConfig.getConfig() == null) continue;
                this.stopAndUninstallBundle(bundleWithConfig.getBundle(), bundleWithConfig.getConfig().getPluginName());
            }
            catch (BundleException e) {
                log.warn("Unable to stop bundle", (Throwable)e);
            }
        }
    }

    public Iterable<BundleWithMetadata> getPureOSGIBundles() {
        return this.registry.values().stream().filter(input -> input != null && input.getConfig() == null).collect(Collectors.toUnmodifiableList());
    }

    public BundleWithMetadata getBundle(String pluginName) {
        return this.registry.get(pluginName);
    }

    public String getPluginName(Bundle bundle) {
        for (BundleWithMetadata cur : this.registry.values()) {
            if (!bundle.getSymbolicName().equals(cur.getBundle().getSymbolicName())) continue;
            return BundleRegistry.getPluginName(cur);
        }
        return bundle.getSymbolicName();
    }

    public void registerService(OSGIServiceDescriptor desc, String serviceName) {
        for (BundleWithMetadata cur : this.registry.values()) {
            if (!desc.getPluginSymbolicName().equals(cur.getBundle().getSymbolicName())) continue;
            cur.register(desc.getRegistrationName(), serviceName);
        }
    }

    public void unregisterService(OSGIServiceDescriptor desc, String serviceName) {
        for (BundleWithMetadata cur : this.registry.values()) {
            if (!desc.getPluginSymbolicName().equals(cur.getBundle().getSymbolicName())) continue;
            cur.unregister(desc.getRegistrationName(), serviceName);
        }
    }

    private static String getPluginName(BundleWithConfig bundleWithConfig) {
        return bundleWithConfig.getConfig() != null && bundleWithConfig.getConfig().getPluginName() != null ? bundleWithConfig.getConfig().getPluginName() : bundleWithConfig.getBundle().getSymbolicName();
    }

    public static class BundleWithMetadata
    extends BundleWithConfig {
        private final Set<PluginServiceInfo> serviceNames = new HashSet<PluginServiceInfo>();

        public BundleWithMetadata(BundleWithConfig bundleWithConfig) {
            super(bundleWithConfig.getBundle(), bundleWithConfig.getConfig());
        }

        public String getPluginName() {
            return BundleRegistry.getPluginName(this);
        }

        public String getVersion() {
            return this.getConfig() != null ? this.getConfig().getVersion() : null;
        }

        public void register(String registrationName, String serviceTypeName) {
            this.serviceNames.add(new DefaultPluginsInfoApi.DefaultPluginServiceInfo(serviceTypeName, registrationName));
        }

        public void unregister(String registrationName, String serviceTypeName) {
            this.serviceNames.remove(new DefaultPluginsInfoApi.DefaultPluginServiceInfo(serviceTypeName, registrationName));
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Set<PluginServiceInfo> getServiceNames() {
            return this.serviceNames;
        }
    }
}

