/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.killbill.commons.metrics.api.Meter;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Timer;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.killbill.commons.utils.Joiner;
import org.killbill.commons.utils.cache.Cache;
import org.killbill.commons.utils.cache.DefaultSynchronizedCache;
import org.killbill.commons.utils.reflect.AbstractInvocationHandler;

public class ContextClassLoaderHelper {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    public static <T> T getWrappedServiceWithCorrectContextClassLoader(T service, Class<T> serviceType, String serviceName, @Nullable MetricRegistry metricRegistry) {
        Class<?> serviceClass = service.getClass();
        List<Class<?>> allServiceInterfaces = ContextClassLoaderHelper.getAllInterfaces(serviceClass);
        Class[] serviceClassInterfaces = allServiceInterfaces.toArray(new Class[allServiceInterfaces.size()]);
        ClassLoaderInvocationHandler<T> handler = new ClassLoaderInvocationHandler<T>(service, serviceName, serviceType, metricRegistry);
        return (T)Proxy.newProxyInstance(serviceClass.getClassLoader(), serviceClassInterfaces, handler);
    }

    private static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
                if (!list.contains(anInterface)) {
                    list.add(anInterface);
                }
                List<Class<?>> superInterfaces = ContextClassLoaderHelper.getAllInterfaces(anInterface);
                for (Class<?> superInterface : superInterfaces) {
                    Class<?> intface = superInterface;
                    if (list.contains(intface)) continue;
                    list.add(intface);
                }
            }
            cls = cls.getSuperclass();
        }
        return list;
    }

    private static class ClassLoaderInvocationHandler<T>
    extends AbstractInvocationHandler {
        private final String serviceName;
        private final T service;
        private final Class<?> serviceClass;
        private final String serviceInterfaceName;
        private final MetricRegistry metricRegistry;
        private Cache<String, Timer> timerMetricCache;
        private Cache<String, Meter> errorMetricCache;

        public ClassLoaderInvocationHandler(T service, String serviceName, Class<T> serviceInterface, MetricRegistry metricRegistry) {
            this.service = service;
            this.serviceName = serviceName;
            this.metricRegistry = serviceInterface == MetricRegistry.class ? null : metricRegistry;
            this.serviceClass = service.getClass();
            this.serviceInterfaceName = serviceInterface.getSimpleName();
            if (this.metricRegistry != null) {
                this.initializeMetricCaches();
            }
        }

        protected Object handleInvocation(Object proxy, final Method method, final Object[] args) throws Throwable {
            ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
            long start = System.nanoTime();
            try {
                Thread.currentThread().setContextClassLoader(this.serviceClass.getClassLoader());
                String methodName = method.getName();
                Profiling prof = new Profiling();
                String profilingId = this.serviceInterfaceName + "." + methodName;
                Object object = prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.PLUGIN, profilingId, (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

                    public Object execute() throws Throwable {
                        return method.invoke(service, args);
                    }
                });
                return object;
            }
            catch (InvocationTargetException e) {
                Optional<Meter> errors = this.errorMeter(method);
                errors.ifPresent(meter -> meter.mark(1L));
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw new RuntimeException(e);
            }
            finally {
                Optional<Timer> times = this.timer(method);
                times.ifPresent(timer -> timer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                Thread.currentThread().setContextClassLoader(initialContextClassLoader);
            }
        }

        private Optional<Timer> timer(Method method) {
            return this.timerMetricCache == null ? Optional.empty() : Optional.of((Timer)this.timerMetricCache.get((Object)method.getName()));
        }

        private Optional<Meter> errorMeter(Method method) {
            return this.errorMetricCache == null ? Optional.empty() : Optional.of((Meter)this.errorMetricCache.get((Object)method.getName()));
        }

        private void initializeMetricCaches() {
            this.timerMetricCache = new DefaultSynchronizedCache(Integer.MAX_VALUE, 0L, methodName -> {
                String timerMetricName = DOT_JOINER.join((Object)"killbill-service", (Object)"kb_plugin_latency", new Object[]{this.serviceName, this.serviceInterfaceName, methodName});
                return this.metricRegistry.timer(timerMetricName);
            });
            this.errorMetricCache = new DefaultSynchronizedCache(Integer.MAX_VALUE, 0L, methodName -> {
                String counterMetricName = DOT_JOINER.join((Object)"killbill-service", (Object)"kb_plugin_errors", new Object[]{this.serviceName, this.serviceInterfaceName, methodName});
                return this.metricRegistry.meter(counterMetricName);
            });
        }
    }
}

