/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.osgi.api.ServiceDiscoveryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServiceRegistryServiceRegistration
implements OSGIServiceRegistration<ServiceDiscoveryRegistry> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistryServiceRegistration.class);
    private final Map<String, ServiceDiscoveryRegistry> pluginRegistrations = new HashMap<String, ServiceDiscoveryRegistry>();

    public void registerService(OSGIServiceDescriptor desc, ServiceDiscoveryRegistry service) {
        logger.info("Registering ServiceRegistry {}", (Object)desc.getRegistrationName());
        this.pluginRegistrations.put(desc.getRegistrationName(), service);
    }

    public void unregisterService(String serviceName) {
        logger.info("Unregistering ServiceRegistry {}", (Object)serviceName);
        this.pluginRegistrations.remove(serviceName);
    }

    public ServiceDiscoveryRegistry getServiceForName(String serviceName) {
        return this.pluginRegistrations.get(serviceName);
    }

    public Set<String> getAllServices() {
        return this.pluginRegistrations.keySet();
    }

    public Class<ServiceDiscoveryRegistry> getServiceType() {
        return ServiceDiscoveryRegistry.class;
    }
}

