/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.osgi.BundleRegistry;
import org.killbill.billing.osgi.api.KillbillNodesApiHolder;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginServiceInfo;
import org.killbill.billing.osgi.api.PluginState;
import org.killbill.billing.osgi.api.PluginStateChange;
import org.killbill.billing.osgi.api.PluginsInfoApi;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;
import org.killbill.billing.osgi.pluginconf.PluginFinder;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginsInfoApi
implements PluginsInfoApi {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPluginsInfoApi.class);
    private final BundleRegistry bundleRegistry;
    private final PluginFinder pluginFinder;
    private final KillbillNodesApi nodesApi;

    @Inject
    public DefaultPluginsInfoApi(BundleRegistry bundleRegistry, PluginFinder pluginFinder, KillbillNodesApiHolder nodesApiHolder) {
        this.bundleRegistry = bundleRegistry;
        this.pluginFinder = pluginFinder;
        this.nodesApi = nodesApiHolder.getNodesApi();
    }

    public Iterable<PluginInfo> getPluginsInfo() {
        ArrayList<DefaultPluginInfo> result = new ArrayList<DefaultPluginInfo>();
        for (String pluginName : this.pluginFinder.getAllPlugins().keySet()) {
            BundleRegistry.BundleWithMetadata installedBundleOrNull = this.bundleRegistry.getBundle(pluginName);
            LinkedList<PluginConfig> pluginVersions = this.pluginFinder.getAllPlugins().get(pluginName);
            boolean isSelectedForStart = true;
            for (PluginConfig curVersion : pluginVersions) {
                DefaultPluginInfo pluginInfo = installedBundleOrNull != null && curVersion.getVersion().equals(installedBundleOrNull.getVersion()) ? new DefaultPluginInfo(curVersion.getPluginKey(), installedBundleOrNull.getBundle().getSymbolicName(), installedBundleOrNull.getPluginName(), installedBundleOrNull.getVersion(), DefaultPluginsInfoApi.toPluginState(installedBundleOrNull), isSelectedForStart, installedBundleOrNull.getServiceNames()) : new DefaultPluginInfo(curVersion.getPluginKey(), null, curVersion.getPluginName(), curVersion.getVersion(), DefaultPluginsInfoApi.toPluginState(null), isSelectedForStart, Collections.emptySet());
                isSelectedForStart = false;
                result.add(pluginInfo);
            }
        }
        for (BundleRegistry.BundleWithMetadata osgiBundle : this.bundleRegistry.getPureOSGIBundles()) {
            if (osgiBundle.getBundle().getSymbolicName() == null) continue;
            DefaultPluginInfo pluginInfo = new DefaultPluginInfo(null, osgiBundle.getBundle().getSymbolicName(), osgiBundle.getPluginName(), osgiBundle.getVersion(), DefaultPluginsInfoApi.toPluginState(osgiBundle), true, Collections.emptySet());
            result.add(pluginInfo);
        }
        return result.stream().sorted(Comparator.comparing(input -> {
            if (input == null) {
                return "";
            }
            StringBuilder tmp = new StringBuilder(input.getPluginName());
            if (input.getVersion() != null) {
                tmp.append(input.getVersion());
            }
            return tmp.toString();
        })).collect(Collectors.toList());
    }

    public void notifyOfStateChanged(PluginStateChange newState, String pluginKey, @Nullable String pluginName, String pluginVersion, @Nullable PluginLanguage pluginLanguage) {
        try {
            this.pluginFinder.reloadPlugins();
            String resolvedPluginName = pluginName != null ? pluginName : (this.pluginFinder.resolvePluginKey(pluginKey) != null ? this.pluginFinder.resolvePluginKey(pluginKey).getPluginName() : null);
            String defaultPluginVersion = this.pluginFinder.getPluginVersionSelectedForStart(resolvedPluginName);
            boolean isSelectedForStart = defaultPluginVersion != null && defaultPluginVersion.equals(pluginVersion);
            switch (newState) {
                case NEW_VERSION: {
                    break;
                }
                case DISABLED: {
                    this.bundleRegistry.stopAndUninstallNewBundle(resolvedPluginName, pluginVersion);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid PluginStateChange " + newState);
                }
            }
            if (this.nodesApi != null) {
                DefaultPluginInfo pluginInfo = new DefaultPluginInfo(pluginKey, null, resolvedPluginName, pluginVersion, DefaultPluginsInfoApi.toPluginState(null), isSelectedForStart, Collections.emptySet());
                this.nodesApi.notifyPluginChanged((PluginInfo)pluginInfo, this.getPluginsInfo());
            }
        }
        catch (PluginConfigException e) {
            logger.error("Failed to handle notifyOfStateChanged: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Failed to handle notifyOfStateChanged: ", (Throwable)e);
        }
        catch (BundleException e) {
            logger.error("Failed to handle notifyOfStateChanged: ", (Throwable)e);
        }
    }

    public static PluginState toPluginState(@Nullable BundleRegistry.BundleWithMetadata bundle) {
        return bundle != null && bundle.getBundle().getState() == 32 ? PluginState.RUNNING : PluginState.STOPPED;
    }

    public static class DefaultPluginServiceInfo
    implements PluginServiceInfo {
        private final String serviceTypeName;
        private final String registrationName;

        public DefaultPluginServiceInfo(String serviceTypeName, String registrationName) {
            this.serviceTypeName = serviceTypeName;
            this.registrationName = registrationName;
        }

        public String getServiceTypeName() {
            return this.serviceTypeName;
        }

        public String getRegistrationName() {
            return this.registrationName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultPluginServiceInfo)) {
                return false;
            }
            DefaultPluginServiceInfo that = (DefaultPluginServiceInfo)o;
            if (this.serviceTypeName != null ? !this.serviceTypeName.equals(that.serviceTypeName) : that.serviceTypeName != null) {
                return false;
            }
            return !(this.registrationName == null ? that.registrationName != null : !this.registrationName.equals(that.registrationName));
        }

        public int hashCode() {
            int result = this.serviceTypeName != null ? this.serviceTypeName.hashCode() : 0;
            result = 31 * result + (this.registrationName != null ? this.registrationName.hashCode() : 0);
            return result;
        }
    }

    public static final class DefaultPluginInfo
    implements PluginInfo {
        private final String pluginKey;
        private final String pluginName;
        private final String pluginSymbolicName;
        private final String version;
        private final Set<PluginServiceInfo> services;
        private final PluginState state;
        private final boolean isSelectedForStart;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public DefaultPluginInfo(String pluginKey, String pluginSymbolicName, String pluginName, String version, PluginState state, boolean isSelectedForStart, Set<PluginServiceInfo> services) {
            this.pluginKey = pluginKey;
            this.pluginSymbolicName = pluginSymbolicName;
            this.pluginName = pluginName;
            this.version = version;
            this.state = state;
            this.isSelectedForStart = isSelectedForStart;
            this.services = services;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getBundleSymbolicName() {
            return this.pluginSymbolicName;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getVersion() {
            return this.version;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Set<PluginServiceInfo> getServices() {
            return this.services;
        }

        public boolean isSelectedForStart() {
            return this.isSelectedForStart;
        }

        public PluginState getPluginState() {
            return this.state;
        }
    }
}

