/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final ServiceTracker<LogService, LogService> logTracker;
    private final ServiceReference SR;

    public OSGIAppender(ServiceTracker<LogService, LogService> logTracker, Bundle bundle) {
        this.logTracker = logTracker;
        this.SR = new RootBundleLogbackServiceReference(bundle);
    }

    protected void append(ILoggingEvent eventObject) {
        int level;
        LogService logService = (LogService)this.logTracker.getService();
        if (logService == null) {
            return;
        }
        switch (eventObject.getLevel().toInt()) {
            case 5000: {
                level = 4;
                break;
            }
            case 10000: {
                level = 4;
                break;
            }
            case 20000: {
                level = 3;
                break;
            }
            case 30000: {
                level = 2;
                break;
            }
            case 40000: {
                level = 1;
                break;
            }
            default: {
                level = 4;
            }
        }
        Throwable t = null;
        if (eventObject.getThrowableProxy() != null) {
            t = eventObject.getThrowableProxy() instanceof ThrowableProxy ? ((ThrowableProxy)eventObject.getThrowableProxy()).getThrowable() : new Throwable(eventObject.getThrowableProxy().getMessage());
        }
        logService.log(this.SR, level, eventObject.getFormattedMessage(), t);
    }

    private static final class RootBundleLogbackServiceReference
    implements ServiceReference {
        private static final Map<String, String> SERVICE_KEYS = Map.of("KILL_BILL_ROOT_LOGGING", "true");
        private final Bundle bundle;

        public RootBundleLogbackServiceReference(Bundle bundle) {
            this.bundle = bundle;
        }

        public Object getProperty(String key) {
            return SERVICE_KEYS.get(key);
        }

        public String[] getPropertyKeys() {
            return SERVICE_KEYS.keySet().toArray(new String[0]);
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException("Not supported yet for RootBundleLogbackServiceReference");
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            throw new UnsupportedOperationException("Not supported yet for RootBundleLogbackServiceReference");
        }

        public Object adapt(Class type) {
            throw new UnsupportedOperationException("Not supported yet for RootBundleLogbackServiceReference");
        }

        public Dictionary getProperties() {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (Map.Entry<String, String> entry : SERVICE_KEYS.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                hashtable.put(entry.getKey(), entry.getValue());
            }
            return hashtable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootBundleLogbackServiceReference that = (RootBundleLogbackServiceReference)o;
            return this.bundle != null ? this.bundle.equals(that.bundle) : that.bundle == null;
        }

        public int hashCode() {
            return this.bundle != null ? this.bundle.hashCode() : 0;
        }

        public int compareTo(Object reference) {
            return this.bundle.compareTo((Object)((Bundle)reference));
        }
    }
}

