/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.pluginconf;

import java.io.File;
import java.util.Properties;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.api.config.PluginType;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;

public abstract class DefaultPluginConfig
implements PluginConfig,
Comparable<PluginConfig> {
    private static final String PROP_PLUGIN_TYPE_NAME = "pluginType";
    private final String pluginKey;
    private final String pluginName;
    private final PluginType pluginType;
    private final String version;
    private final File pluginVersionRoot;
    private final boolean isSelectedForStart;
    private final boolean isDisabled;

    public DefaultPluginConfig(DefaultPluginConfig input, boolean isSelectedForStart) {
        this.pluginKey = input.getPluginKey();
        this.pluginName = input.getPluginName();
        this.version = input.getVersion();
        this.pluginVersionRoot = input.getPluginVersionRoot();
        this.isSelectedForStart = isSelectedForStart;
        this.pluginType = input.getPluginType();
        this.isDisabled = input.isDisabled();
    }

    public DefaultPluginConfig(String pluginKey, String pluginName, String version, Properties props, File pluginVersionRoot, boolean isVersionToStartLinkedToMe, boolean isDisabled) {
        this.pluginKey = pluginKey;
        this.pluginName = pluginName;
        this.version = version;
        this.pluginVersionRoot = pluginVersionRoot;
        this.isSelectedForStart = isVersionToStartLinkedToMe;
        this.pluginType = PluginType.valueOf((String)props.getProperty(PROP_PLUGIN_TYPE_NAME, PluginType.__UNKNOWN__.toString()));
        this.isDisabled = isDisabled;
    }

    public final String getPluginKey() {
        return this.pluginKey;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPluginVersionnedName() {
        return this.pluginName + "-" + this.version;
    }

    public File getPluginVersionRoot() {
        return this.pluginVersionRoot;
    }

    public boolean isSelectedForStart() {
        return this.isSelectedForStart;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public abstract PluginLanguage getPluginLanguage();

    protected abstract void validate() throws PluginConfigException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((PluginConfig)o) == 0;
    }

    public int hashCode() {
        int result = this.pluginName != null ? this.pluginName.hashCode() : 0;
        result = 31 * result + (this.pluginType != null ? this.pluginType.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.pluginVersionRoot != null ? this.pluginVersionRoot.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultPluginConfig");
        sb.append("{pluginName='").append(this.pluginName).append('\'');
        sb.append(", pluginType=").append(this.pluginType);
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", pluginVersionRoot=").append(this.pluginVersionRoot);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(PluginConfig o) {
        if (this.isSelectedForStart) {
            return -1;
        }
        if (o.isSelectedForStart()) {
            return 1;
        }
        return o.getVersion().compareTo(this.getVersion());
    }
}

