/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.osgi.BundleWithConfig;
import org.killbill.billing.osgi.PureOSGIBundleFinder;
import org.killbill.billing.osgi.api.KillbillNodesApiHolder;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginConfigServiceApi;
import org.killbill.billing.osgi.api.config.PluginJavaConfig;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.pluginconf.DefaultPluginConfigServiceApi;
import org.killbill.billing.osgi.pluginconf.PluginConfigException;
import org.killbill.billing.osgi.pluginconf.PluginFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInstall {
    private static final Logger logger = LoggerFactory.getLogger(FileInstall.class);
    private final PureOSGIBundleFinder osgiBundleFinder;
    private final PluginFinder pluginFinder;
    private final PluginConfigServiceApi pluginConfigServiceApi;

    @Inject
    public FileInstall(PureOSGIBundleFinder osgiBundleFinder, PluginFinder pluginFinder, KillbillNodesApiHolder nodesApiHolder, PluginConfigServiceApi pluginConfigServiceApi) {
        this.osgiBundleFinder = osgiBundleFinder;
        this.pluginFinder = pluginFinder;
        this.pluginConfigServiceApi = pluginConfigServiceApi;
    }

    public List<BundleWithConfig> installBundles(Framework framework) {
        LinkedList<BundleWithConfig> installedBundles = new LinkedList<BundleWithConfig>();
        try {
            BundleContext context = framework.getBundleContext();
            this.installAllOSGIBundles(context, installedBundles);
            this.installAllJavaPluginBundles(context, installedBundles);
        }
        catch (PluginConfigException e) {
            logger.error("Error while parsing plugin configurations", (Throwable)e);
        }
        catch (BundleException e) {
            logger.error("Error while parsing plugin configurations", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while parsing plugin configurations", (Throwable)e);
        }
        return installedBundles;
    }

    public BundleWithConfig installNewBundle(String pluginName, @Nullable String version, Framework framework) {
        try {
            String osgiBundlePath = this.osgiBundleFinder.getOSGIPath(pluginName);
            if (osgiBundlePath != null) {
                Bundle bundle = this.installOSGIBundle(framework.getBundleContext(), osgiBundlePath);
                return new BundleWithConfig(bundle, null);
            }
            List<PluginConfig> configs = this.pluginFinder.getVersionsForPlugin(pluginName, version);
            if (configs.isEmpty() || version != null && configs.size() != 1) {
                throw new PluginConfigException("Cannot install plugin " + pluginName + ", version = " + version);
            }
            Bundle bundle = this.installBundle(configs.get(0), framework.getBundleContext(), configs.get(0).getPluginLanguage());
            return new BundleWithConfig(bundle, configs.get(0));
        }
        catch (PluginConfigException e) {
            logger.error("Error while installing plugin " + pluginName, (Throwable)e);
        }
        catch (BundleException e) {
            logger.error("Error while installing plugin" + pluginName, (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while installing plugin " + pluginName, (Throwable)e);
        }
        return null;
    }

    private void installAllOSGIBundles(BundleContext context, List<BundleWithConfig> installedBundles) throws PluginConfigException, BundleException {
        List<String> bundleJarPaths = this.osgiBundleFinder.getLatestBundles();
        for (String cur : bundleJarPaths) {
            try {
                Bundle bundle = this.installOSGIBundle(context, cur);
                installedBundles.add(new BundleWithConfig(bundle, null));
            }
            catch (BundleException e) {
                logger.error("Error while installing bundle {}, ignoring", (Object)cur, (Object)e);
            }
        }
    }

    private Bundle installOSGIBundle(BundleContext context, String path) throws BundleException {
        logger.info("Installing Java OSGI bundle from {}", (Object)path);
        Bundle bundle = context.installBundle("file:" + path);
        this.osgiBundleFinder.recordMappingPluginNameToPath(bundle.getSymbolicName(), path);
        return bundle;
    }

    private void installAllJavaPluginBundles(BundleContext context, List<BundleWithConfig> installedBundles) throws PluginConfigException, BundleException, IOException {
        List<PluginJavaConfig> pluginJavaConfigs = this.pluginFinder.getLatestJavaPlugins();
        for (PluginJavaConfig cur : pluginJavaConfigs) {
            Bundle bundle = this.installBundle((PluginConfig)cur, context, PluginLanguage.JAVA);
            installedBundles.add(new BundleWithConfig(bundle, (PluginConfig)cur));
        }
    }

    private Bundle installBundle(PluginConfig config, BundleContext context, PluginLanguage pluginLanguage) throws BundleException {
        Bundle bundle;
        switch (pluginLanguage) {
            case JAVA: {
                PluginJavaConfig javaConfig = (PluginJavaConfig)config;
                String location = "file:" + javaConfig.getBundleJarPath();
                bundle = context.getBundle(location);
                if (bundle != null) break;
                logger.info("Installing Java bundle for plugin {} from {}", (Object)javaConfig.getPluginName(), (Object)javaConfig.getBundleJarPath());
                bundle = context.installBundle(location);
                ((DefaultPluginConfigServiceApi)this.pluginConfigServiceApi).registerBundle((Long)bundle.getBundleId(), javaConfig);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown pluginLanguage " + pluginLanguage);
            }
        }
        return bundle;
    }

    public boolean startBundle(Bundle bundle) {
        if (bundle.getState() == 1) {
            logger.info("Skipping uninstalled bundle {}", (Object)bundle.getLocation());
        } else if (this.isFragment(bundle)) {
            logger.info("Skipping fragment bundle {}", (Object)bundle.getLocation());
        } else {
            logger.info("Starting bundle {}", (Object)bundle.getLocation());
            try {
                bundle.start();
                return true;
            }
            catch (BundleException e) {
                logger.warn("Unable to start bundle", (Throwable)e);
            }
        }
        return false;
    }

    private boolean isFragment(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return bundleRevision != null && (bundleRevision.getTypes() & 1) != 0;
    }
}

