/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.http;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.killbill.billing.osgi.ContextClassLoaderHelper;
import org.killbill.billing.osgi.http.DefaultHttpContext;
import org.killbill.billing.osgi.http.DefaultServletRouter;
import org.killbill.billing.osgi.http.StaticServlet;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

@Singleton
public class DefaultHttpService
implements HttpService {
    private final DefaultServletRouter servletRouter;
    private final MetricRegistry metricsRegistry;

    @Inject
    public DefaultHttpService(DefaultServletRouter servletRouter, MetricRegistry metricsRegistry) {
        this.servletRouter = servletRouter;
        this.metricsRegistry = metricsRegistry;
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException {
        if (alias == null) {
            throw new IllegalArgumentException("Invalid alias (null)");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Invalid servlet (null)");
        }
        Servlet wrappedServlet = ContextClassLoaderHelper.getWrappedServiceWithCorrectContextClassLoader(servlet, Servlet.class, alias, this.metricsRegistry);
        this.servletRouter.registerServiceFromPath(alias, wrappedServlet);
    }

    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        StaticServlet staticServlet = new StaticServlet(httpContext);
        try {
            this.registerServlet(alias, (Servlet)staticServlet, new Hashtable(), httpContext);
        }
        catch (ServletException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void unregister(String alias) {
        this.servletRouter.unregisterServiceFromPath(alias);
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext();
    }
}

