/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.http.HttpContext;

public class StaticServlet
extends HttpServlet {
    private final HttpContext httpContext;

    public StaticServlet(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL url = this.findResourceURL(req);
        if (url != null) {
            try (InputStream is = url.openStream();){
                is.transferTo((OutputStream)resp.getOutputStream());
                resp.setStatus(200);
                return;
            }
        }
        RequestDispatcher rd = this.getServletContext().getNamedDispatcher("default");
        HttpServletRequestWrapper wrapped = new HttpServletRequestWrapper(req){

            public String getServletPath() {
                return "";
            }
        };
        rd.forward((ServletRequest)wrapped, (ServletResponse)resp);
    }

    private URL findResourceURL(HttpServletRequest request) {
        String url = request.getRequestURI();
        for (int i = 0; i < url.lastIndexOf(47); ++i) {
            String resourceName;
            URL match;
            int idx = url.indexOf(47, i);
            if (idx <= -1 || (match = this.findResourceURL(resourceName = url.substring(idx))) == null) continue;
            return match;
        }
        return null;
    }

    private URL findResourceURL(String resourceName) {
        URL url = this.httpContext.getResource(resourceName);
        if (url == null) {
            url = this.httpContext.getClass().getResource(resourceName);
        }
        return url;
    }
}

