/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi;

import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.OSGISingleServiceRegistration;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricRegistryServiceRegistration
implements OSGISingleServiceRegistration<MetricRegistry> {
    private static final Logger logger = LoggerFactory.getLogger(MetricRegistryServiceRegistration.class);
    private Map.Entry<String, MetricRegistry> pluginRegistration;
    private final List<Runnable> listeners = new LinkedList<Runnable>();

    public void registerService(OSGIServiceDescriptor desc, MetricRegistry service) {
        if (this.pluginRegistration != null) {
            logger.warn("MetricRegistry {} is already registered, ignoring {}", (Object)this.pluginRegistration.getKey(), (Object)desc.getRegistrationName());
        } else {
            logger.info("Registering MetricRegistry {}", (Object)desc.getRegistrationName());
            this.pluginRegistration = new AbstractMap.SimpleEntry<String, MetricRegistry>(desc.getRegistrationName(), service);
            this.onServiceChange();
        }
    }

    public void unregisterService(String serviceName) {
        if (this.pluginRegistration == null || !this.pluginRegistration.getKey().equals(serviceName)) {
            return;
        }
        this.pluginRegistration = null;
        this.onServiceChange();
    }

    public MetricRegistry getService() {
        if (this.pluginRegistration == null) {
            return null;
        }
        return this.pluginRegistration.getValue();
    }

    public Class<MetricRegistry> getServiceType() {
        return MetricRegistry.class;
    }

    public void addRegistrationListener(Runnable listener) {
        this.listeners.add(listener);
    }

    private void onServiceChange() {
        for (Runnable runnable : this.listeners) {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                logger.warn("Ignoring Service Listener exception", (Throwable)e);
            }
        }
    }
}

