/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.glue;

import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.sql.DataSource;
import org.killbill.billing.osgi.BundleRegistry;
import org.killbill.billing.osgi.DefaultOSGIKillbill;
import org.killbill.billing.osgi.DefaultOSGIService;
import org.killbill.billing.osgi.FileInstall;
import org.killbill.billing.osgi.KillbillActivator;
import org.killbill.billing.osgi.KillbillEventObservable;
import org.killbill.billing.osgi.KillbillEventRetriableBusHandler;
import org.killbill.billing.osgi.OSGIListener;
import org.killbill.billing.osgi.PureOSGIBundleFinder;
import org.killbill.billing.osgi.api.DefaultPluginsInfoApi;
import org.killbill.billing.osgi.api.KillbillEventRetriableBusHandlerService;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.api.OSGIKillbill;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.osgi.api.PluginsInfoApi;
import org.killbill.billing.osgi.api.config.PluginConfigServiceApi;
import org.killbill.billing.osgi.config.OSGIConfig;
import org.killbill.billing.osgi.glue.OSGIDataSourceConfig;
import org.killbill.billing.osgi.http.DefaultHttpService;
import org.killbill.billing.osgi.http.DefaultServletRouter;
import org.killbill.billing.osgi.http.OSGIServlet;
import org.killbill.billing.osgi.pluginconf.DefaultPluginConfigServiceApi;
import org.killbill.billing.osgi.pluginconf.PluginFinder;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.api.OSGIService;
import org.killbill.billing.platform.glue.KillBillPlatformModuleBase;
import org.killbill.billing.platform.glue.ReferenceableDataSourceSpyProvider;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.jdbi.guice.DaoConfig;
import org.osgi.service.http.HttpService;
import org.skife.config.ConfigurationObjectFactory;

public class DefaultOSGIModule
extends KillBillPlatformModuleBase {
    public static final String OSGI_NAMED = "osgi";
    private final OSGIConfigProperties osgiConfigProperties;
    private final OSGIDataSourceConfig osgiDataSourceConfig;
    private final EmbeddedDB osgiEmbeddedDB;

    public DefaultOSGIModule(KillbillConfigSource configSource, OSGIConfigProperties osgiConfigProperties, OSGIDataSourceConfig osgiDataSourceConfig, EmbeddedDB osgiEmbeddedDB) {
        super(configSource);
        this.osgiConfigProperties = osgiConfigProperties;
        this.osgiDataSourceConfig = osgiDataSourceConfig;
        this.osgiEmbeddedDB = osgiEmbeddedDB;
    }

    protected void installConfig() {
        OSGIConfig config = (OSGIConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(OSGIConfig.class);
        this.bind(OSGIConfig.class).toInstance((Object)config);
        this.bind(OSGIConfigProperties.class).toInstance((Object)this.osgiConfigProperties);
    }

    protected void installOSGIServlet() {
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<Servlet>>(){}).to(DefaultServletRouter.class).asEagerSingleton();
        this.bind(HttpServlet.class).annotatedWith((Annotation)Names.named((String)OSGI_NAMED)).to(OSGIServlet.class).asEagerSingleton();
    }

    protected void installDataSource() {
        this.bind(OSGIDataSourceConfig.class).toInstance((Object)this.osgiDataSourceConfig);
        this.bind(DaoConfig.class).annotatedWith((Annotation)Names.named((String)OSGI_NAMED)).toInstance((Object)this.osgiDataSourceConfig);
        ReferenceableDataSourceSpyProvider dataSourceSpyProvider = new ReferenceableDataSourceSpyProvider((DaoConfig)this.osgiDataSourceConfig, this.osgiEmbeddedDB, OSGI_NAMED);
        this.requestInjection(dataSourceSpyProvider);
        this.bind(DataSource.class).annotatedWith((Annotation)Names.named((String)OSGI_NAMED)).toProvider((Provider)dataSourceSpyProvider).asEagerSingleton();
    }

    protected void installOSGIComponents() {
        this.bind(OSGIService.class).to(DefaultOSGIService.class).asEagerSingleton();
        this.bind(OSGIListener.class).asEagerSingleton();
        this.bind(BundleRegistry.class).asEagerSingleton();
        this.bind(FileInstall.class).asEagerSingleton();
        this.bind(KillbillActivator.class).asEagerSingleton();
        this.bind(PureOSGIBundleFinder.class).asEagerSingleton();
        this.bind(PluginFinder.class).asEagerSingleton();
        this.bind(PluginConfigServiceApi.class).to(DefaultPluginConfigServiceApi.class).asEagerSingleton();
        this.bind(OSGIKillbill.class).to(DefaultOSGIKillbill.class).asEagerSingleton();
        this.bind(KillbillEventObservable.class).asEagerSingleton();
        this.bind(KillbillEventRetriableBusHandlerService.class).to(KillbillEventRetriableBusHandler.class);
        this.bind(KillbillEventRetriableBusHandler.class).asEagerSingleton();
        this.bind(PluginsInfoApi.class).to(DefaultPluginsInfoApi.class).asEagerSingleton();
    }

    protected void installHttpService() {
        this.bind(HttpService.class).to(DefaultHttpService.class).asEagerSingleton();
    }

    protected void configure() {
        this.installConfig();
        this.installOSGIServlet();
        this.installHttpService();
        this.installDataSource();
        this.installOSGIComponents();
    }
}

