/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.updatechecker;

import com.google.common.base.Objects;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import java.net.InetAddress;
import javax.servlet.ServletContext;
import org.skife.config.ConfigSource;

public class ClientInfo {
    private static final String UNKNOWN = "UNKNOWN";
    private static int CLIENT_ID;
    private final ServletContext servletContext;
    private final ConfigSource props;

    public ClientInfo(ConfigSource configSource, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.props = configSource;
    }

    public String getServletMajorVersion() {
        return this.getSanitizedString(String.valueOf(this.servletContext.getMajorVersion()));
    }

    public String getServletMinorVersion() {
        return this.getSanitizedString(String.valueOf(this.servletContext.getMinorVersion()));
    }

    public String getServletEffectiveMajorVersion() {
        return this.getSanitizedString(String.valueOf(this.servletContext.getEffectiveMajorVersion()));
    }

    public String getServletEffectiveMinorVersion() {
        return this.getSanitizedString(String.valueOf(this.servletContext.getEffectiveMinorVersion()));
    }

    public String getServerInfo() {
        return this.getSanitizedString(this.servletContext.getServerInfo());
    }

    public String getClientId() {
        return String.valueOf(CLIENT_ID);
    }

    public String getJavaVersion() {
        return this.getProperty(StandardSystemProperty.JAVA_VERSION);
    }

    public String getJavaVendor() {
        return this.getProperty(StandardSystemProperty.JAVA_VENDOR);
    }

    public String getJavaVendorURL() {
        return this.getProperty(StandardSystemProperty.JAVA_VENDOR_URL);
    }

    public String getJavaVMSpecificationVersion() {
        return this.getProperty(StandardSystemProperty.JAVA_VM_SPECIFICATION_VERSION);
    }

    public String getJavaVMSpecificationVendor() {
        return this.getProperty(StandardSystemProperty.JAVA_VM_SPECIFICATION_VENDOR);
    }

    public String getJavaVMSpecificationName() {
        return this.getProperty(StandardSystemProperty.JAVA_VM_SPECIFICATION_NAME);
    }

    public String getJavaVMVersion() {
        return this.getProperty(StandardSystemProperty.JAVA_VM_VERSION);
    }

    public String getJavaVMVendor() {
        return this.getProperty(StandardSystemProperty.JAVA_VM_VENDOR);
    }

    public String getJavaVMName() {
        return this.getProperty(StandardSystemProperty.JAVA_VM_NAME);
    }

    public String getJavaSpecificationVersion() {
        return this.getProperty(StandardSystemProperty.JAVA_SPECIFICATION_VERSION);
    }

    public String getJavaSpecificationVendor() {
        return this.getProperty(StandardSystemProperty.JAVA_SPECIFICATION_VENDOR);
    }

    public String getJavaSpecificationName() {
        return this.getProperty(StandardSystemProperty.JAVA_SPECIFICATION_NAME);
    }

    public String getJavaClassVersion() {
        return this.getProperty(StandardSystemProperty.JAVA_CLASS_VERSION);
    }

    public String getJavaCompiler() {
        return this.getProperty(StandardSystemProperty.JAVA_COMPILER);
    }

    public String getPlatform() {
        return this.getProperty(StandardSystemProperty.OS_ARCH);
    }

    public String getOSName() {
        return this.getProperty(StandardSystemProperty.OS_NAME);
    }

    public String getOSArch() {
        return this.getProperty(StandardSystemProperty.OS_ARCH);
    }

    public String getOSVersion() {
        return this.getProperty(StandardSystemProperty.OS_VERSION);
    }

    private String getProperty(StandardSystemProperty standardKey) {
        return this.getSanitizedString((String)Objects.firstNonNull((Object)this.props.getString(standardKey.key()), (Object)UNKNOWN));
    }

    private String getSanitizedString(String string) {
        return Strings.isNullOrEmpty((String)string) ? UNKNOWN : string.trim();
    }

    static {
        try {
            CLIENT_ID = InetAddress.getLocalHost().hashCode();
        }
        catch (Throwable t) {
            CLIENT_ID = 0;
        }
    }
}

