/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.modules;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jdbi.InstrumentedTimingCollector;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.killbill.billing.lifecycle.glue.BusModule;
import org.killbill.billing.lifecycle.glue.LifecycleModule;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.glue.DefaultOSGIModule;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;
import org.killbill.billing.platform.glue.KillBillPlatformModuleBase;
import org.killbill.billing.platform.glue.NotificationQueueModule;
import org.killbill.billing.platform.glue.ReferenceableDataSourceSpyProvider;
import org.killbill.billing.platform.jndi.JNDIManager;
import org.killbill.billing.server.config.KillbillServerConfig;
import org.killbill.billing.server.modules.EmbeddedDBProvider;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.killbill.clock.DefaultClock;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.jdbi.guice.DBIProvider;
import org.killbill.commons.jdbi.guice.DaoConfig;
import org.killbill.commons.jdbi.notification.DatabaseTransactionNotificationApi;
import org.killbill.commons.jdbi.transaction.NotificationTransactionHandler;
import org.killbill.commons.jdbi.transaction.RestartTransactionRunner;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.tweak.TransactionHandler;

public class KillbillPlatformModule
extends KillBillPlatformModuleBase {
    protected final ServletContext servletContext;
    protected final KillbillServerConfig serverConfig;
    protected DaoConfig daoConfig;

    public KillbillPlatformModule(ServletContext servletContext, KillbillServerConfig serverConfig, KillbillConfigSource configSource) {
        super(configSource);
        this.servletContext = servletContext;
        this.serverConfig = serverConfig;
    }

    protected void configure() {
        this.configureClock();
        this.configureDao();
        this.configureConfig();
        this.configureEmbeddedDB();
        this.configureLifecycle();
        this.configureBuses();
        this.configureNotificationQ();
        this.configureOSGI();
        this.configureJNDI();
    }

    protected void configureClock() {
        if (this.serverConfig.isTestModeEnabled()) {
            this.bind(Clock.class).to(ClockMock.class).asEagerSingleton();
        } else {
            this.bind(Clock.class).to(DefaultClock.class).asEagerSingleton();
        }
    }

    protected void configureDao() {
        this.daoConfig = (DaoConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(DaoConfig.class);
        this.bind(DaoConfig.class).toInstance((Object)this.daoConfig);
        DatabaseTransactionNotificationApi databaseTransactionNotificationApi = new DatabaseTransactionNotificationApi();
        this.bind(DatabaseTransactionNotificationApi.class).toInstance((Object)databaseTransactionNotificationApi);
        NotificationTransactionHandler notificationTransactionHandler = new NotificationTransactionHandler(databaseTransactionNotificationApi);
        RestartTransactionRunner ourSuperTunedTransactionHandler = new RestartTransactionRunner((TransactionHandler)notificationTransactionHandler);
        this.bind(TransactionHandler.class).toInstance((Object)ourSuperTunedTransactionHandler);
        this.bind(IDBI.class).toProvider(DBIProvider.class).asEagerSingleton();
        this.bind(IDBI.class).annotatedWith((Annotation)Names.named((String)"Queue")).toProvider(DBIProvider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    protected DataSource provideDataSourceInAComplicatedWayBecauseOf627(Injector injector) {
        ReferenceableDataSourceSpyProvider dataSourceSpyProvider = new ReferenceableDataSourceSpyProvider(this.daoConfig, "main");
        injector.injectMembers((Object)dataSourceSpyProvider);
        return (DataSource)dataSourceSpyProvider.get();
    }

    @Provides
    @Named(value="shiro")
    @Singleton
    protected DataSource provideShiroDataSourceInAComplicatedWayBecauseOf627(Injector injector) {
        ReferenceableDataSourceSpyProvider dataSourceSpyProvider = new ReferenceableDataSourceSpyProvider(this.daoConfig, "shiro");
        injector.injectMembers((Object)dataSourceSpyProvider);
        return (DataSource)dataSourceSpyProvider.get();
    }

    @Provides
    @Singleton
    protected TimingCollector provideTimingCollector(MetricRegistry metricRegistry) {
        return new InstrumentedTimingCollector(metricRegistry);
    }

    protected void configureConfig() {
        this.bind(ConfigSource.class).toInstance((Object)this.skifeConfigSource);
        this.bind(KillbillServerConfig.class).toInstance((Object)this.serverConfig);
    }

    protected void configureEmbeddedDB() {
        this.bind(EmbeddedDB.class).toProvider(EmbeddedDBProvider.class).asEagerSingleton();
    }

    protected void configureLifecycle() {
        this.install((Module)new LifecycleModule());
    }

    protected void configureBuses() {
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, false, this.configSource));
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, true, this.configSource));
    }

    protected void configureNotificationQ() {
        this.install((Module)new NotificationQueueModule(this.configSource));
    }

    protected void configureOSGI() {
        this.install((Module)new DefaultOSGIModule(this.configSource, (OSGIConfigProperties)((DefaultKillbillConfigSource)this.configSource)));
    }

    protected void configureJNDI() {
        this.bind(JNDIManager.class).asEagerSingleton();
    }
}

