/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.updatechecker;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.JGoogleAnalyticsTracker;
import javax.servlet.ServletContext;
import org.killbill.billing.server.updatechecker.ClientInfo;
import org.killbill.billing.server.updatechecker.ProductInfo;
import org.skife.config.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracker {
    private static final Logger log = LoggerFactory.getLogger(Tracker.class);
    private static final String TRACKING_CODE = "UA-44821278-1";
    final ProductInfo productInfo;
    private final ClientInfo clientInfo;
    private final JGoogleAnalyticsTracker tracker;

    public Tracker(ConfigSource configSource, ProductInfo productInfo, ServletContext context) {
        this.productInfo = productInfo;
        this.clientInfo = new ClientInfo(configSource, context);
        AnalyticsConfigData analyticsConfigData = new AnalyticsConfigData(TRACKING_CODE);
        this.tracker = new JGoogleAnalyticsTracker(analyticsConfigData, JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
    }

    public void track() {
        this.trackProperty("product", "name", this.productInfo.getName());
        this.trackProperty("product", "version", this.productInfo.getVersion());
        this.trackProperty("product", "builtBy", this.productInfo.getBuiltBy());
        this.trackProperty("product", "buildJdk", this.productInfo.getBuildJdk());
        this.trackProperty("product", "buildTime", this.productInfo.getBuildTime());
        this.trackProperty("product", "enterprise", String.valueOf(this.productInfo.isEnterprise()));
        this.trackProperty("client", "servletMajorVersion", this.clientInfo.getServletMajorVersion());
        this.trackProperty("client", "servletMinorVersion", this.clientInfo.getServletMinorVersion());
        this.trackProperty("client", "servletEffectiveMajorVersion", this.clientInfo.getServletEffectiveMajorVersion());
        this.trackProperty("client", "servletEffectiveMinorVersion", this.clientInfo.getServletEffectiveMinorVersion());
        this.trackProperty("client", "serverInfo", this.clientInfo.getServerInfo());
        this.trackProperty("client", "clientId", this.clientInfo.getClientId());
        this.trackProperty("client", "javaVersion", this.clientInfo.getJavaVersion());
        this.trackProperty("client", "javaVendor", this.clientInfo.getJavaVendor());
        this.trackProperty("client", "javaVendorURL", this.clientInfo.getJavaVendorURL());
        this.trackProperty("client", "javaVMSpecificationVersion", this.clientInfo.getJavaVMSpecificationVersion());
        this.trackProperty("client", "javaVMSpecificationVendor", this.clientInfo.getJavaVMSpecificationVendor());
        this.trackProperty("client", "javaVMSpecificationName", this.clientInfo.getJavaVMSpecificationName());
        this.trackProperty("client", "javaVMVersion", this.clientInfo.getJavaVMVersion());
        this.trackProperty("client", "javaVMVendor", this.clientInfo.getJavaVMVendor());
        this.trackProperty("client", "javaVMName", this.clientInfo.getJavaVMName());
        this.trackProperty("client", "javaSpecificationVersion", this.clientInfo.getJavaSpecificationVersion());
        this.trackProperty("client", "javaSpecificationVendor", this.clientInfo.getJavaSpecificationVendor());
        this.trackProperty("client", "javaSpecificationName", this.clientInfo.getJavaSpecificationName());
        this.trackProperty("client", "javaClassVersion", this.clientInfo.getJavaClassVersion());
        this.trackProperty("client", "javaCompiler", this.clientInfo.getJavaCompiler());
        this.trackProperty("client", "platform", this.clientInfo.getPlatform());
        this.trackProperty("client", "osName", this.clientInfo.getOSName());
        this.trackProperty("client", "osArch", this.clientInfo.getOSArch());
        this.trackProperty("client", "osVersion", this.clientInfo.getOSVersion());
    }

    private void trackProperty(String category, String key, String value) {
        String sanitizedValue = value;
        sanitizedValue = sanitizedValue.replace('(', '-');
        sanitizedValue = sanitizedValue.replace(')', '-');
        log.debug("Tracking {}: {}={}", new Object[]{category, key, sanitizedValue});
        this.tracker.trackEvent(category, key, sanitizedValue);
    }
}

