/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.listeners;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.StatusViaSLF4JLoggerFactory;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.logback.InstrumentedAppender;
import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import com.izettle.metrics.dw.InfluxDbReporterFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;
import org.killbill.billing.server.config.KillbillServerConfig;
import org.killbill.billing.server.config.MetricsGraphiteConfig;
import org.killbill.billing.server.config.MetricsInfluxDbConfig;
import org.killbill.billing.server.healthchecks.KillbillHealthcheck;
import org.killbill.billing.server.healthchecks.KillbillQueuesHealthcheck;
import org.killbill.billing.server.modules.KillbillPlatformModule;
import org.killbill.bus.api.PersistentBus;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.skeleton.listeners.GuiceServletContextListener;
import org.killbill.commons.skeleton.modules.BaseServerModuleBuilder;
import org.killbill.commons.skeleton.modules.JMXModule;
import org.killbill.commons.skeleton.modules.JaxrsJacksonModule;
import org.killbill.commons.skeleton.modules.StatsModule;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.MBeanExporter;

public class KillbillPlatformGuiceListener
extends GuiceServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(KillbillPlatformGuiceListener.class);
    public static final ImmutableList<String> METRICS_SERVLETS_PATHS = ImmutableList.of((Object)"/1.0/healthcheck", (Object)"/1.0/metrics", (Object)"/1.0/ping", (Object)"/1.0/threads");
    protected KillbillHealthcheck killbillHealthcheck;
    protected KillbillServerConfig config;
    protected KillbillConfigSource configSource;
    protected MetricsGraphiteConfig metricsGraphiteConfig;
    protected MetricsInfluxDbConfig metricsInfluxDbConfig;
    protected Injector injector;
    protected Lifecycle killbillLifecycle;
    protected BusService killbillBusService;
    protected EmbeddedDB mainEmbeddedDB;
    protected EmbeddedDB shiroEmbeddedDB;
    protected EmbeddedDB osgiEmbeddedDB;
    protected JmxReporter metricsJMXReporter;

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.initializeConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initializeGuice(event);
        this.initializeMetrics(event);
        this.registerEhcacheMBeans();
        this.startLifecycle();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.putOutOfRotation();
        super.contextDestroyed(sce);
        if (this.killbillLifecycle == null) {
            return;
        }
        this.stopLifecycle();
        this.stopEmbeddedDBs();
        this.stopMetrics();
        this.removeJMXExports();
        this.stopLogging();
    }

    protected void initializeConfig() throws IOException, URISyntaxException {
        this.configSource = this.getConfigSource();
        ConfigurationObjectFactory configFactory = new ConfigurationObjectFactory((ConfigSource)new KillbillPlatformConfigSource(this.configSource));
        this.config = (KillbillServerConfig)configFactory.build(KillbillServerConfig.class);
        this.metricsGraphiteConfig = (MetricsGraphiteConfig)configFactory.build(MetricsGraphiteConfig.class);
        this.metricsInfluxDbConfig = (MetricsInfluxDbConfig)configFactory.build(MetricsInfluxDbConfig.class);
    }

    protected KillbillConfigSource getConfigSource() throws IOException, URISyntaxException {
        return new DefaultKillbillConfigSource();
    }

    protected void initializeGuice(ServletContextEvent event) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((com.fasterxml.jackson.databind.Module)new JodaModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.guiceModules = ImmutableList.of((Object)this.getServletModule(), (Object)this.getJacksonModule(), (Object)new JMXModule(new Class[]{KillbillHealthcheck.class, KillbillQueuesHealthcheck.class, NotificationQueueService.class, PersistentBus.class}), (Object)new StatsModule((String)METRICS_SERVLETS_PATHS.get(0), (String)METRICS_SERVLETS_PATHS.get(1), (String)METRICS_SERVLETS_PATHS.get(2), (String)METRICS_SERVLETS_PATHS.get(3), (Iterable)ImmutableList.of(KillbillHealthcheck.class, KillbillQueuesHealthcheck.class, ThreadDeadlockHealthCheck.class)), (Object)this.getModule(event.getServletContext()));
        super.contextInitialized(event);
        this.injector = this.injector(event);
        event.getServletContext().setAttribute(Injector.class.getName(), (Object)this.injector);
        this.mainEmbeddedDB = (EmbeddedDB)this.injector.getInstance(EmbeddedDB.class);
        this.shiroEmbeddedDB = (EmbeddedDB)this.injector.getInstance(Key.get(EmbeddedDB.class, (Annotation)Names.named((String)"shiro")));
        this.osgiEmbeddedDB = (EmbeddedDB)this.injector.getInstance(Key.get(EmbeddedDB.class, (Annotation)Names.named((String)"osgi")));
        this.killbillLifecycle = (Lifecycle)this.injector.getInstance(Lifecycle.class);
        this.killbillBusService = (BusService)this.injector.getInstance(BusService.class);
        this.killbillHealthcheck = (KillbillHealthcheck)((Object)this.injector.getInstance(KillbillHealthcheck.class));
    }

    protected ServletModule getServletModule() {
        BaseServerModuleBuilder builder = new BaseServerModuleBuilder();
        return builder.build();
    }

    protected Module getModule(ServletContext servletContext) {
        return new KillbillPlatformModule(servletContext, this.config, this.configSource);
    }

    protected JaxrsJacksonModule getJacksonModule() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((com.fasterxml.jackson.databind.Module)new JodaModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return new JaxrsJacksonModule(objectMapper);
    }

    protected void initializeMetrics(ServletContextEvent event) {
        GraphiteReporter reporter;
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        MetricRegistry metricRegistry = (MetricRegistry)this.injector.getInstance(MetricRegistry.class);
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if ("ch.qos.logback.classic.LoggerContext".equals(factory.getClass().getName())) {
            ch.qos.logback.classic.Logger root = ((LoggerContext)factory).getLogger("ROOT");
            InstrumentedAppender metrics = new InstrumentedAppender(metricRegistry);
            metrics.setContext((Context)root.getLoggerContext());
            metrics.start();
            root.addAppender((Appender)metrics);
        } else {
            logger.info("{} not a logback logger factory, {} not started", (Object)factory, (Object)metricRegistry);
        }
        this.registerAll("buffers", (MetricSet)new BufferPoolMetricSet(platformMBeanServer), metricRegistry);
        this.registerAll("classloading", (MetricSet)new ClassLoadingGaugeSet(), metricRegistry);
        this.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet(), metricRegistry);
        this.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet(), metricRegistry);
        this.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet(), metricRegistry);
        this.metricsJMXReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).registerWith(platformMBeanServer).build();
        this.metricsJMXReporter.start();
        if (this.metricsGraphiteConfig.isGraphiteReportingEnabled()) {
            Graphite graphite = new Graphite(new InetSocketAddress(this.metricsGraphiteConfig.getHostname(), this.metricsGraphiteConfig.getPort()));
            reporter = GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith(this.metricsGraphiteConfig.getPrefix()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.NANOSECONDS).filter(MetricFilter.ALL).build(graphite);
            reporter.start((long)this.metricsGraphiteConfig.getInterval(), TimeUnit.SECONDS);
            logger.info(String.format("reporting metrics to %s:%d", this.metricsGraphiteConfig.getHostname(), this.metricsGraphiteConfig.getPort()));
        }
        if (this.metricsInfluxDbConfig.isInfluxDbReportingEnabled()) {
            InfluxDbReporterFactory influxDbReporterFactory = new InfluxDbReporterFactory();
            influxDbReporterFactory.setRateUnit(TimeUnit.SECONDS);
            influxDbReporterFactory.setDurationUnit(TimeUnit.NANOSECONDS);
            influxDbReporterFactory.setHost(this.metricsInfluxDbConfig.getHostname());
            influxDbReporterFactory.setPort(this.metricsInfluxDbConfig.getPort());
            influxDbReporterFactory.setReadTimeout(this.metricsInfluxDbConfig.getSocketTimeout());
            influxDbReporterFactory.setDatabase(this.metricsInfluxDbConfig.getDatabase());
            influxDbReporterFactory.setPrefix(this.metricsInfluxDbConfig.getPrefix());
            influxDbReporterFactory.setSenderType(this.metricsInfluxDbConfig.getSenderType());
            reporter = influxDbReporterFactory.build(metricRegistry);
            reporter.start((long)this.metricsInfluxDbConfig.getInterval(), TimeUnit.SECONDS);
            logger.info(String.format("reporting metrics to %s:%d", this.metricsInfluxDbConfig.getHostname(), this.metricsInfluxDbConfig.getPort()));
        }
        event.getServletContext().setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, this.injector.getInstance(HealthCheckRegistry.class));
        event.getServletContext().setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)metricRegistry);
        event.getServletContext().setAttribute(InstrumentedFilter.REGISTRY_ATTRIBUTE, (Object)metricRegistry);
    }

    private void registerAll(String prefix, MetricSet metricSet, MetricRegistry registry) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    protected void registerEhcacheMBeans() {
    }

    protected void startLifecycle() {
        this.startLifecycleStage1();
        this.killbillLifecycle.fireStartupSequencePriorEventRegistration();
        this.startLifecycleStage2();
        this.killbillLifecycle.fireStartupSequencePostEventRegistration();
        this.startLifecycleStage3();
    }

    protected void startLifecycleStage1() {
    }

    protected void startLifecycleStage2() {
    }

    protected void startLifecycleStage3() {
    }

    protected void putOutOfRotation() {
        if (this.killbillHealthcheck != null) {
            this.killbillHealthcheck.putOutOfRotation();
            if (this.config.getShutdownDelay() != null && this.config.getShutdownDelay().getMillis() > 0L) {
                logger.info("Delaying shutdown sequence for {}ms", (Object)this.config.getShutdownDelay().getMillis());
                try {
                    Thread.sleep(this.config.getShutdownDelay().getMillis());
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted while sleeping", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                logger.info("Resuming shutdown sequence");
            }
        }
    }

    protected void stopLifecycle() {
        this.stopLifecycleStage1();
        this.killbillLifecycle.fireShutdownSequencePriorEventUnRegistration();
        this.stopLifecycleStage2();
        this.killbillLifecycle.fireShutdownSequencePostEventUnRegistration();
        this.stopLifecycleStage3();
    }

    protected void stopLifecycleStage1() {
    }

    protected void stopLifecycleStage2() {
    }

    protected void stopLifecycleStage3() {
    }

    protected void stopEmbeddedDBs() {
        this.stopEmbeddedDB(this.osgiEmbeddedDB);
        this.stopEmbeddedDB(this.shiroEmbeddedDB);
        this.stopEmbeddedDB(this.mainEmbeddedDB);
    }

    protected void stopEmbeddedDB(EmbeddedDB embeddedDB) {
        if (embeddedDB != null) {
            try {
                embeddedDB.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void stopMetrics() {
        if (this.metricsJMXReporter != null) {
            this.metricsJMXReporter.stop();
        }
    }

    private void removeJMXExports() {
        MBeanExporter mBeanExporter = (MBeanExporter)this.injector.getInstance(MBeanExporter.class);
        if (mBeanExporter != null) {
            mBeanExporter.unexportAllAndReportMissing();
        }
    }

    protected void stopLogging() {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (iLoggerFactory instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)iLoggerFactory;
            ContextAwareBase contextAwareBase = new ContextAwareBase();
            contextAwareBase.setContext((Context)loggerContext);
            StatusViaSLF4JLoggerFactory.addInfo((String)("About to stop " + loggerContext.getClass().getCanonicalName() + " [" + loggerContext.getName() + "]"), (Object)((Object)this));
            loggerContext.stop();
        }
    }

    @VisibleForTesting
    public Injector getInstantiatedInjector() {
        return this.injector;
    }

    private static final class KillbillPlatformConfigSource
    implements ConfigSource {
        private final KillbillConfigSource configSource;

        private KillbillPlatformConfigSource(KillbillConfigSource configSource) {
            this.configSource = configSource;
        }

        public String getString(String propertyName) {
            return this.configSource.getString(propertyName);
        }
    }
}

