/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.updatechecker;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.killbill.billing.server.config.UpdateCheckConfig;
import org.killbill.billing.server.updatechecker.ProductInfo;
import org.killbill.billing.server.updatechecker.Tracker;
import org.killbill.billing.server.updatechecker.UpdateListProperties;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateChecker {
    private static final Logger log = LoggerFactory.getLogger(UpdateChecker.class);
    private final ConfigSource configSource;
    private final UpdateCheckConfig config;

    public UpdateChecker(ConfigSource configSource) {
        this.configSource = configSource;
        this.config = (UpdateCheckConfig)new ConfigurationObjectFactory(configSource).build(UpdateCheckConfig.class);
    }

    public void check(final ServletContext servletContext) {
        log.info("For Kill Bill Commercial Support, visit http://thebillingproject.com or send an email to support@thebillingproject.com");
        if (this.shouldSkipUpdateCheck()) {
            return;
        }
        Thread t = new Thread(){

            public void run() {
                try {
                    UpdateChecker.this.doCheck(servletContext);
                }
                catch (IOException e) {
                    log.debug("Unable to perform update check", (Throwable)e);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheck(ServletContext servletContext) throws IOException {
        ProductInfo productInfo = new ProductInfo();
        UpdateListProperties updateListProperties = new UpdateListProperties(this.config.updateCheckURL().toURL(), this.config.updateCheckConnectionTimeout());
        if (updateListProperties.getGeneralNotice() != null) {
            log.info(updateListProperties.getGeneralNotice());
        }
        if (updateListProperties.getNoticeForVersion(productInfo.getVersion()) != null) {
            log.info(updateListProperties.getNoticeForVersion(productInfo.getVersion()));
        }
        StringBuilder updates = new StringBuilder();
        for (String update : updateListProperties.getUpdatesForVersion(productInfo.getVersion())) {
            if (updates.length() > 0) {
                updates.append(", ");
            }
            updates.append(update);
            String changeLog = updateListProperties.getReleaseNotesForVersion(update);
            if (changeLog == null) continue;
            updates.append(" [").append(changeLog).append("]");
        }
        if (updates.length() > 0) {
            log.info("New update(s) found: " + updates.toString() + ". Please check http://killbill.io for the latest version.");
        }
        Tracker tracker = new Tracker(this.configSource, productInfo, servletContext);
        try {
            tracker.track();
        }
        finally {
            tracker.close();
        }
    }

    private boolean shouldSkipUpdateCheck() {
        if (this.config.shouldSkipUpdateCheck()) {
            return true;
        }
        try {
            Class.forName("org.testng.Assert");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

