/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.healthchecks;

public class HoltWintersComputer {
    private final FILTERING_TYPE filteringType;
    private double value;
    private double alpha;
    private double beta;
    private double gamma;
    private double baseline;
    private double slope;
    private double[] seasonalValues;
    private int seenValues = 0;
    private double lastForecast;

    public HoltWintersComputer(double alpha) {
        this.alpha = alpha;
        this.filteringType = FILTERING_TYPE.SIMPLE;
    }

    public HoltWintersComputer(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.filteringType = FILTERING_TYPE.DOUBLE;
    }

    public HoltWintersComputer(double alpha, double beta, double gamma, int period) {
        this.alpha = alpha;
        this.beta = beta;
        this.gamma = gamma;
        this.seasonalValues = new double[period];
        this.filteringType = FILTERING_TYPE.TRIPLE;
    }

    public void addNextValue(double value) {
        this.lastForecast = this.getForecast(1);
        this.value = value;
        this.updateParameters();
        ++this.seenValues;
    }

    public double getDeviation() {
        return Math.abs(this.value - this.lastForecast);
    }

    public double getForecast(int h) {
        if (this.filteringType == FILTERING_TYPE.SIMPLE) {
            return this.baseline;
        }
        if (this.filteringType == FILTERING_TYPE.DOUBLE) {
            return this.baseline + (double)h * this.slope;
        }
        if (this.filteringType == FILTERING_TYPE.TRIPLE) {
            return this.baseline + (double)h * this.slope + this.seasonalValues[(this.seasonalValues.length - 1 + (h - 1) % this.seasonalValues.length) % this.seasonalValues.length];
        }
        throw new IllegalStateException("Computer not initialized properly");
    }

    private void updateParameters() {
        switch (this.filteringType) {
            case SIMPLE: {
                this.updateParametersSimpleExponential();
                break;
            }
            case DOUBLE: {
                this.updateParametersDoubleExponential();
                break;
            }
            case TRIPLE: {
                this.updateParametersTripleExponential();
                break;
            }
            default: {
                throw new IllegalStateException("Computer not initialized properly");
            }
        }
    }

    private void updateParametersTripleExponential() {
        if (this.seenValues == 0) {
            this.baseline = this.value;
            this.seasonalValues[this.seenValues] = this.value;
        } else if (this.seenValues == 1) {
            this.slope = this.value - this.baseline;
            this.baseline = this.value;
            this.seasonalValues[this.seenValues] = this.value;
        } else if (this.seenValues < this.seasonalValues.length) {
            this.seasonalValues[this.seenValues] = this.value;
        } else {
            double oldBaseline = this.baseline;
            double oldSlope = this.slope;
            double oldSeasonal = this.seasonalValues[0];
            System.arraycopy(this.seasonalValues, 1, this.seasonalValues, 0, this.seasonalValues.length - 1);
            this.baseline = this.alpha * (this.value - oldSeasonal) + (1.0 - this.alpha) * (oldBaseline + oldSlope);
            this.slope = this.beta * (this.baseline - oldBaseline) + (1.0 - this.beta) * oldSlope;
            this.seasonalValues[this.seasonalValues.length - 1] = this.gamma * (this.value - this.baseline) + (1.0 - this.gamma) * oldSeasonal;
        }
    }

    private void updateParametersDoubleExponential() {
        if (this.seenValues == 0) {
            this.baseline = this.value;
        } else if (this.seenValues == 1) {
            this.slope = this.value - this.baseline;
            this.baseline = this.value;
        } else {
            double oldBaseline = this.baseline;
            double oldSlope = this.slope;
            this.baseline = this.alpha * this.value + (1.0 - this.alpha) * (oldBaseline + oldSlope);
            this.slope = this.beta * (this.baseline - oldBaseline) + (1.0 - this.beta) * oldSlope;
        }
    }

    private void updateParametersSimpleExponential() {
        if (this.seenValues == 0) {
            this.baseline = this.value;
        } else {
            double oldBaseline = this.baseline;
            this.baseline = this.alpha * this.value + (1.0 - this.alpha) * oldBaseline;
        }
    }

    public String toString() {
        return String.format("alpha=%f, beta=%f, gamma=%f", this.alpha, this.beta, this.gamma);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double[] getSeasonal() {
        return this.seasonalValues;
    }

    static enum FILTERING_TYPE {
        SIMPLE,
        DOUBLE,
        TRIPLE;

    }
}

