/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.dao;

import java.net.URI;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.GenericStandaloneDB;
import org.killbill.commons.embeddeddb.h2.H2EmbeddedDB;
import org.killbill.commons.embeddeddb.mysql.MySQLStandaloneDB;
import org.killbill.commons.embeddeddb.postgresql.PostgreSQLStandaloneDB;
import org.killbill.commons.jdbi.guice.DaoConfig;

public class EmbeddedDBFactory {
    private EmbeddedDBFactory() {
    }

    public static EmbeddedDB get(DaoConfig config) {
        String databaseName;
        String schemeLocation;
        URI uri = URI.create(config.getJdbcUrl().substring(5));
        if (uri.getPath() != null) {
            schemeLocation = null;
            databaseName = uri.getPath().split("/")[1].split(";")[0];
        } else if (uri.getSchemeSpecificPart() != null) {
            String[] schemeParts = uri.getSchemeSpecificPart().split(":");
            schemeLocation = schemeParts[0];
            databaseName = schemeParts[1].split(";")[0];
        } else {
            schemeLocation = null;
            databaseName = null;
        }
        if ("mysql".equals(uri.getScheme())) {
            return new MySQLStandaloneDB(databaseName, config.getUsername(), config.getPassword(), config.getJdbcUrl());
        }
        if ("h2".equals(uri.getScheme()) && ("mem".equals(schemeLocation) || "file".equals(schemeLocation))) {
            return new H2EmbeddedDB(databaseName, config.getUsername(), config.getPassword(), config.getJdbcUrl());
        }
        if ("postgresql".equals(uri.getScheme())) {
            return new PostgreSQLStandaloneDB(databaseName, config.getUsername(), config.getPassword(), config.getJdbcUrl());
        }
        return new GenericStandaloneDB(databaseName, config.getUsername(), config.getPassword(), config.getJdbcUrl());
    }
}

