/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.modules;

import com.google.inject.Provider;
import javax.inject.Inject;
import org.killbill.billing.server.config.KillbillServerConfig;
import org.killbill.clock.DistributedClockMock;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public class DistributedClockProvider
implements Provider<DistributedClockMock> {
    private final KillbillServerConfig serverConfig;

    @Inject
    public DistributedClockProvider(KillbillServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public DistributedClockMock get() {
        Config redissonCfg = new Config();
        redissonCfg.useSingleServer().setAddress(this.serverConfig.getUrl()).setConnectionMinimumIdleSize(this.serverConfig.getConnectionMinimumIdleSize());
        RedissonClient redissonClient = Redisson.create((Config)redissonCfg);
        DistributedClockMock distributedClockMock = new DistributedClockMock();
        distributedClockMock.setRedissonClient(redissonClient);
        return distributedClockMock;
    }
}

