/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import org.killbill.billing.server.healthchecks.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.Managed;

@Singleton
public class KillbillHealthcheck
extends HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(KillbillHealthcheck.class);
    private static final String OK = "OK";
    private static final String OUT_OF_ROTATION = "Out of rotation";
    private final AtomicBoolean outOfRotation = new AtomicBoolean(true);
    private Set<ServiceRegistry> serviceRegistries = Collections.emptySet();

    @Inject(optional=true)
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setServiceRegistries(Set<ServiceRegistry> serviceRegistries) {
        this.serviceRegistries = serviceRegistries;
    }

    public HealthCheck.Result check() {
        if (this.outOfRotation.get()) {
            return this.buildHealthcheckResponse(false, OUT_OF_ROTATION);
        }
        return this.buildHealthcheckResponse(true, OK);
    }

    @Managed(description="Basic killbill healthcheck")
    public boolean isHealthy() {
        return this.check().isHealthy();
    }

    @Managed(description="Put in rotation")
    public void putInRotation() {
        logger.warn("Putting host in rotation");
        this.outOfRotation.set(false);
        for (ServiceRegistry serviceRegistry : this.serviceRegistries) {
            logger.info("Registering ServiceRegistry {}", (Object)serviceRegistry);
            try {
                serviceRegistry.register();
            }
            catch (RuntimeException e) {
                logger.warn("Failed to register ServiceRegistry {}. Exception: {}", (Object)serviceRegistry, (Object)e);
            }
        }
    }

    @Managed(description="Put out of rotation")
    public void putOutOfRotation() {
        logger.warn("Putting host out of rotation");
        this.outOfRotation.set(true);
        for (ServiceRegistry serviceRegistry : this.serviceRegistries) {
            logger.info("Unregistering ServiceRegistry {}", (Object)serviceRegistry);
            try {
                serviceRegistry.unregister();
            }
            catch (RuntimeException e) {
                logger.warn("Failed to unregister ServiceRegistry {}. Exception: {}", (Object)serviceRegistry, (Object)e);
            }
        }
    }

    private HealthCheck.Result buildHealthcheckResponse(boolean healthy, String message) {
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder();
        if (healthy) {
            resultBuilder.healthy();
        } else {
            resultBuilder.unhealthy();
        }
        return resultBuilder.withMessage(message).build();
    }
}

