/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.modules;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import javax.inject.Inject;
import org.killbill.billing.server.dao.EmbeddedDBFactory;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.jdbi.guice.DaoConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDBProvider
implements Provider<EmbeddedDB> {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedDBProvider.class);
    private final DaoConfig config;

    @Inject
    public EmbeddedDBProvider(DaoConfig config) {
        this.config = config;
    }

    public EmbeddedDB get() {
        EmbeddedDB embeddedDB = EmbeddedDBFactory.get(this.config);
        if (EmbeddedDB.DBEngine.H2.equals((Object)embeddedDB.getDBEngine())) {
            try {
                this.initializeEmbeddedDB(embeddedDB);
            }
            catch (IOException e) {
                logger.error("Error while initializing H2, opportunistically continuing the startup sequence", (Throwable)e);
            }
            catch (SQLException e) {
                logger.error("Error while initializing H2, opportunistically continuing the startup sequence", (Throwable)e);
            }
        }
        return embeddedDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeEmbeddedDB(EmbeddedDB embeddedDB) throws IOException, SQLException {
        embeddedDB.initialize();
        embeddedDB.start();
        if (!embeddedDB.getAllTables().isEmpty()) {
            return;
        }
        for (String ddlFile : this.getDDLFiles()) {
            URL resource;
            try {
                URI uri = new URI(ddlFile);
                String scheme = uri.getScheme();
                resource = scheme == null ? Resources.getResource((String)ddlFile) : new File(uri.getSchemeSpecificPart()).toURI().toURL();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
            try (InputStream inputStream = resource.openStream();){
                String ddl = this.streamToString(inputStream);
                embeddedDB.executeScript(ddl);
            }
        }
        embeddedDB.refreshTableNames();
    }

    protected Iterable<String> getDDLFiles() {
        String seedFile = System.getProperty("org.killbill.dao.seedFile");
        return seedFile == null ? ImmutableList.of() : ImmutableList.of((Object)seedFile);
    }

    protected String streamToString(InputStream inputStream) throws IOException {
        return new String(ByteStreams.toByteArray((InputStream)inputStream), Charsets.UTF_8);
    }
}

