/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.joda.time.DateTime;
import org.killbill.billing.server.healthchecks.HoltWintersComputer;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.Managed;

@Async(initialState=Async.InitialState.HEALTHY, initialDelay=0L, period=1L, unit=TimeUnit.MINUTES, scheduleType=Async.ScheduleType.FIXED_DELAY)
@Singleton
public class KillbillQueuesHealthcheck
extends HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(KillbillQueuesHealthcheck.class);
    private static final int SLIDING_WINDOW_SIZE = 60;
    private static final double ALPHA = 0.3;
    private final Map<String, QueueStats> statsPerQueue = new HashMap<String, QueueStats>();
    private final AtomicBoolean healthcheckActive = new AtomicBoolean(false);
    private final Clock clock;
    private final PersistentBus bus;
    private final PersistentBus externalBus;
    private final NotificationQueueService notificationQueueService;

    @Inject
    public KillbillQueuesHealthcheck(Clock clock, NotificationQueueService notificationQueueService, PersistentBus bus, @Named(value="externalBus") PersistentBus externalBus) {
        this.clock = clock;
        this.notificationQueueService = notificationQueueService;
        this.bus = bus;
        this.externalBus = externalBus;
    }

    @Managed(description="Kill Bill queues healthcheck")
    public boolean isHealthy() {
        HealthCheck.Result result = this.check();
        logger.info("Queues healthcheck result: {}", (Object)result);
        return result.isHealthy();
    }

    @Managed(description="Deactivate healthcheck")
    public void deactivateHealthcheck() {
        logger.warn("Deactivating healthcheck: queues results will be ignored");
        this.healthcheckActive.set(false);
    }

    @Managed(description="Activate healthcheck")
    public void activateHealthcheck() {
        logger.warn("Activating healthcheck: queues results will be NOT be ignored");
        this.healthcheckActive.set(true);
    }

    public HealthCheck.Result check() {
        return this.check(60, 0.3);
    }

    @VisibleForTesting
    HealthCheck.Result check(int slidingWindowSize, double alpha) {
        long nbReadyEntries2;
        DateTime now = this.clock.getUTCNow();
        if (this.bus != null) {
            try {
                nbReadyEntries2 = this.bus.getNbReadyEntries(now);
                this.updateRegression("bus", now.getMillis(), nbReadyEntries2, slidingWindowSize, alpha);
            }
            catch (UnsupportedOperationException nbReadyEntries2) {
                // empty catch block
            }
        }
        if (this.externalBus != null) {
            try {
                nbReadyEntries2 = this.externalBus.getNbReadyEntries(now);
                this.updateRegression("externalBus", now.getMillis(), nbReadyEntries2, slidingWindowSize, alpha);
            }
            catch (UnsupportedOperationException nbReadyEntries3) {
                // empty catch block
            }
        }
        for (NotificationQueue notificationQueue : this.notificationQueueService.getNotificationQueues()) {
            String notificationQueueId = notificationQueue.getFullQName();
            try {
                long nbReadyEntries4 = notificationQueue.getNbReadyEntries(now);
                this.updateRegression(notificationQueueId, now.getMillis(), nbReadyEntries4, slidingWindowSize, alpha);
            }
            catch (UnsupportedOperationException nbReadyEntries4) {}
        }
        HealthCheck.Result healthcheckResponse = this.buildHealthcheckResponse();
        for (Object queueStatsObject : healthcheckResponse.getDetails().values()) {
            QueueStats queueStats = (QueueStats)queueStatsObject;
            logger.debug("healthy='{}', message='{}', error='{}', queue='{}', rawSize='{}', smoothedSize='{}', smoothedSizeSlope='{}'", new Object[]{healthcheckResponse.isHealthy(), healthcheckResponse.getMessage(), healthcheckResponse.getError(), queueStats.queueId, queueStats.lastRawSize, queueStats.lastSmoothedSize, queueStats.currentSmoothedSizesSlope});
        }
        return healthcheckResponse;
    }

    private void updateRegression(String queueId, long now, long nbReadyEntries, int slidingWindowSize, double alpha) {
        if (this.statsPerQueue.get(queueId) == null) {
            this.statsPerQueue.put(queueId, new QueueStats(queueId, slidingWindowSize, alpha));
        }
        this.statsPerQueue.get(queueId).record(now, nbReadyEntries);
    }

    private HealthCheck.Result buildHealthcheckResponse() {
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder();
        StringBuilder stringBuilderForMessage = new StringBuilder("Growing queues: ");
        boolean healthy = true;
        int i = 0;
        for (Map.Entry<String, QueueStats> entry : this.statsPerQueue.entrySet()) {
            QueueStats queueStats = entry.getValue();
            if (queueStats.isGrowing()) {
                healthy = false;
                if (i > 0) {
                    stringBuilderForMessage.append(", ");
                }
                ++i;
                stringBuilderForMessage.append(entry.getKey()).append(" (").append(queueStats.currentSmoothedSizesSlope).append(")");
            }
            resultBuilder.withDetail(entry.getKey(), (Object)queueStats);
        }
        if (healthy || !this.healthcheckActive.get()) {
            resultBuilder.healthy();
        } else {
            resultBuilder.unhealthy().withMessage(stringBuilderForMessage.toString());
        }
        return resultBuilder.build();
    }

    @VisibleForTesting
    static final class QueueStats {
        private final String queueId;
        private final double slidingWindowSize;
        private final EvictingQueue<Long> timestamps;
        private final EvictingQueue<Long> rawSizes;
        private final EvictingQueue<Double> smoothedSizes;
        private final SimpleRegression smoothedSizesRegression;
        private final HoltWintersComputer holtWintersComputer;
        private Double currentSmoothedSizesSlope = 0.0;
        private Long lastRawSize;
        private double lastSmoothedSize;

        public QueueStats(String queueId, int slidingWindowSize, double alpha) {
            this.queueId = queueId;
            this.slidingWindowSize = slidingWindowSize;
            this.timestamps = EvictingQueue.create((int)slidingWindowSize);
            this.rawSizes = EvictingQueue.create((int)slidingWindowSize);
            this.smoothedSizes = EvictingQueue.create((int)slidingWindowSize);
            this.smoothedSizesRegression = new SimpleRegression(true);
            this.holtWintersComputer = new HoltWintersComputer(alpha);
        }

        public void record(long newestTimestamp, long newestRawSize) {
            if ((double)this.smoothedSizesRegression.getN() >= this.slidingWindowSize) {
                Long oldestTimestamp = (Long)this.timestamps.peek();
                Double oldestSmoothedSize = (Double)this.smoothedSizes.peek();
                this.smoothedSizesRegression.removeData((double)oldestTimestamp.longValue(), oldestSmoothedSize.doubleValue());
            }
            this.holtWintersComputer.addNextValue(newestRawSize);
            double newestSmoothedSize = this.holtWintersComputer.getForecast(1);
            this.smoothedSizesRegression.addData((double)newestTimestamp, newestSmoothedSize);
            if ((double)this.smoothedSizesRegression.getN() >= this.slidingWindowSize) {
                double rawSmoothedSlope = this.smoothedSizesRegression.getSlope();
                this.currentSmoothedSizesSlope = Double.isNaN(rawSmoothedSlope) ? 0.0 : new BigDecimal(rawSmoothedSlope * 100.0).setScale(2, 4).doubleValue();
            }
            this.timestamps.add((Object)newestTimestamp);
            this.rawSizes.add((Object)newestRawSize);
            this.smoothedSizes.add((Object)newestSmoothedSize);
            this.lastRawSize = newestRawSize;
            this.lastSmoothedSize = newestSmoothedSize;
        }

        public boolean isGrowing() {
            return this.currentSmoothedSizesSlope > 0.1;
        }

        @VisibleForTesting
        EvictingQueue<Long> getTimestamps() {
            return this.timestamps;
        }

        @VisibleForTesting
        EvictingQueue<Long> getRawSizes() {
            return this.rawSizes;
        }

        @VisibleForTesting
        EvictingQueue<Double> getSmoothedSizes() {
            return this.smoothedSizes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("QueueStats{");
            sb.append("queueId='").append(this.queueId).append('\'');
            sb.append(", slidingWindowSize=").append(this.slidingWindowSize);
            sb.append(", timestamps=").append(this.timestamps);
            sb.append(", rawSizes=").append(this.rawSizes);
            sb.append(", smoothedSizes=").append(this.smoothedSizes);
            sb.append(", currentSmoothedSizesSlope=").append(this.currentSmoothedSizesSlope).append("%");
            sb.append('}');
            return sb.toString();
        }
    }
}

